/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.CascadeType;
import org.hibernate.metamodel.binding.state.SimpleAttributeBindingState;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.binding.AbstractHbmAttributeBindingState;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLParamElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MappingDefaults;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public class HbmSimpleAttributeBindingState
extends AbstractHbmAttributeBindingState
implements SimpleAttributeBindingState {
    private final String typeName;
    private final Map<String, String> typeParameters = new HashMap<String, String>();
    private final boolean isLazy;
    private final PropertyGeneration propertyGeneration;
    private final boolean isInsertable;
    private final boolean isUpdatable;

    public HbmSimpleAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLHibernateMapping.XMLClass.XMLId id) {
        super(ownerClassName, id.getName() != null ? id.getName() : bindingContext.getMappingDefaults().getIdColumnName(), bindingContext, id.getNode(), HbmHelper.extractMetaAttributeContext(id.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(id.getAccess(), false, bindingContext.getMappingDefaults().getPropertyAccessorName()), true);
        this.isLazy = false;
        this.typeName = id.getTypeAttribute() != null ? HbmSimpleAttributeBindingState.maybeConvertToTypeDefName(id.getTypeAttribute(), bindingContext.getMappingDefaults()) : (id.getType() != null ? HbmSimpleAttributeBindingState.maybeConvertToTypeDefName(id.getType().getName(), bindingContext.getMappingDefaults()) : this.getTypeNameByReflection());
        this.propertyGeneration = PropertyGeneration.parse(null);
        this.isInsertable = true;
        this.isUpdatable = false;
    }

    private static String maybeConvertToTypeDefName(String typeName, MappingDefaults defaults) {
        String actualTypeName = typeName;
        if (typeName != null) {
            // empty if block
        }
        return actualTypeName;
    }

    public HbmSimpleAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLHibernateMapping.XMLClass.XMLVersion version) {
        super(ownerClassName, version.getName(), bindingContext, version.getNode(), HbmHelper.extractMetaAttributeContext(version.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(version.getAccess(), false, bindingContext.getMappingDefaults().getPropertyAccessorName()), true);
        this.typeName = version.getType() == null ? "integer" : version.getType();
        this.isLazy = false;
        this.propertyGeneration = PropertyGeneration.parse(version.getGenerated().value());
        if (this.propertyGeneration == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        this.isInsertable = MappingHelper.getBooleanValue(version.isInsert(), true);
        this.isUpdatable = true;
    }

    public HbmSimpleAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLHibernateMapping.XMLClass.XMLTimestamp timestamp) {
        super(ownerClassName, timestamp.getName(), bindingContext, timestamp.getNode(), HbmHelper.extractMetaAttributeContext(timestamp.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(timestamp.getAccess(), false, bindingContext.getMappingDefaults().getPropertyAccessorName()), true);
        this.typeName = "db".equals(timestamp.getSource()) ? "dbtimestamp" : "timestamp";
        this.isLazy = false;
        this.propertyGeneration = PropertyGeneration.parse(timestamp.getGenerated().value());
        if (this.propertyGeneration == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        this.isInsertable = true;
        this.isUpdatable = true;
    }

    public HbmSimpleAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLPropertyElement property) {
        super(ownerClassName, property.getName(), bindingContext, property.getNode(), HbmHelper.extractMetaAttributeContext(property.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(property.getAccess(), false, bindingContext.getMappingDefaults().getPropertyAccessorName()), property.isOptimisticLock());
        this.isLazy = property.isLazy();
        this.propertyGeneration = PropertyGeneration.parse(property.getGenerated());
        if (this.propertyGeneration == PropertyGeneration.ALWAYS || this.propertyGeneration == PropertyGeneration.INSERT) {
            if (property.isInsert() != null && property.isInsert().booleanValue()) {
                throw new MappingException("cannot specify both insert=\"true\" and generated=\"" + this.propertyGeneration.getName() + "\" for property: " + property.getName());
            }
            this.isInsertable = false;
        } else {
            this.isInsertable = MappingHelper.getBooleanValue(property.isInsert(), true);
        }
        if (this.propertyGeneration == PropertyGeneration.ALWAYS) {
            if (property.isUpdate() != null && property.isUpdate().booleanValue()) {
                throw new MappingException("cannot specify both update=\"true\" and generated=\"" + this.propertyGeneration.getName() + "\" for property: " + property.getName());
            }
            this.isUpdatable = false;
        } else {
            this.isUpdatable = MappingHelper.getBooleanValue(property.isUpdate(), true);
        }
        if (property.getTypeAttribute() != null) {
            this.typeName = HbmSimpleAttributeBindingState.maybeConvertToTypeDefName(property.getTypeAttribute(), bindingContext.getMappingDefaults());
        } else if (property.getType() != null) {
            this.typeName = HbmSimpleAttributeBindingState.maybeConvertToTypeDefName(property.getType().getName(), bindingContext.getMappingDefaults());
            for (XMLParamElement typeParameter : property.getType().getParam()) {
                this.typeParameters.put(typeParameter.getName(), typeParameter.getValue().trim());
            }
        } else {
            this.typeName = this.getTypeNameByReflection();
        }
    }

    protected boolean isEmbedded() {
        return false;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Map<String, String> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public PropertyGeneration getPropertyGeneration() {
        return this.propertyGeneration;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public Set<CascadeType> getCascadeTypes() {
        return null;
    }

    @Override
    public boolean isKeyCascadeDeleteEnabled() {
        return false;
    }

    @Override
    public String getUnsavedValue() {
        return null;
    }
}

