/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.source.spi.MetadataImplementor;

public class JavaClassNameResolver {
    private final MetadataImplementor metadata;

    JavaClassNameResolver(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    public void resolve(EntityBinding entityBinding) {
        String entityClassName;
        Entity entity = entityBinding.getEntity();
        if (entity == null) {
            throw new MappingException("Cannot resolve Java type names because the domain model has not been bound to EntityBinding.");
        }
        String string = entityClassName = entity.getPojoEntitySpecifics().getClassName() != null ? entity.getPojoEntitySpecifics().getClassName() : entity.getPojoEntitySpecifics().getProxyInterfaceName();
        if (entityClassName == null) {
            throw new MappingException("No Java class or interface defined for: " + entityBinding.getEntity().getName());
        }
        for (Attribute attribute : entity.getAttributes()) {
            SingularAttribute singularAttribute;
            if (attribute.isSingular() && (singularAttribute = (SingularAttribute)SingularAttribute.class.cast(attribute)).getSingularAttributeType().getName() != null) continue;
        }
    }
}

