/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.component.ComponentEntityModeToTuplizerMapping;

public class ComponentMetamodel
implements Serializable {
    private final String role;
    private final boolean isKey;
    private final StandardProperty[] properties;
    private final ComponentEntityModeToTuplizerMapping tuplizerMapping;
    private final int propertySpan;
    private final Map propertyIndexes = new HashMap();

    public ComponentMetamodel(Component component) {
        this.role = component.getRoleName();
        this.isKey = component.isKey();
        this.propertySpan = component.getPropertySpan();
        this.properties = new StandardProperty[this.propertySpan];
        Iterator itr = component.getPropertyIterator();
        int i = 0;
        while (itr.hasNext()) {
            Property property = (Property)itr.next();
            this.properties[i] = PropertyFactory.buildStandardProperty(property, false);
            this.propertyIndexes.put(property.getName(), i);
            ++i;
        }
        this.tuplizerMapping = new ComponentEntityModeToTuplizerMapping(component);
    }

    public boolean isKey() {
        return this.isKey;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public StandardProperty getProperty(int index) {
        if (index < 0 || index >= this.propertySpan) {
            throw new IllegalArgumentException("illegal index value for component property access [request=" + index + ", span=" + this.propertySpan + "]");
        }
        return this.properties[index];
    }

    public int getPropertyIndex(String propertyName) {
        Integer index = (Integer)this.propertyIndexes.get(propertyName);
        if (index == null) {
            throw new HibernateException("component does not contain such a property [" + propertyName + "]");
        }
        return index;
    }

    public StandardProperty getProperty(String propertyName) {
        return this.getProperty(this.getPropertyIndex(propertyName));
    }

    public ComponentEntityModeToTuplizerMapping getTuplizerMapping() {
        return this.tuplizerMapping;
    }
}

