/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    APPEND("append"),
    AUTOFLUSH("autoflush"),
    CATEGORY("category"),
    FILE_NAME("file-name"),
    MIN_INCLUSIVE("min-inclusive"),
    MIN_LEVEL("min-level"),
    MAX_BACKUP_INDEX("max-backup-index"),
    MAX_INCLUSIVE("max-inclusive"),
    MAX_LEVEL("max-level"),
    NAME("name"),
    NEW_LEVEL("new-level"),
    OVERFLOW_ACTION("overflow-action"),
    PATH("path"),
    PATTERN("pattern"),
    QUEUE_LENGTH("queue-length"),
    RELATIVE_TO("relative-to"),
    REPLACEMENT("replacement"),
    REPLACE_ALL("replace-all"),
    ROTATE_SIZE("rotate-size"),
    SUFFIX("suffix"),
    TARGET("target"),
    USE_PARENT_HANDLERS("use-parent-handlers"),
    VALUE("value");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public static Map<String, Attribute> getMap() {
        return MAP;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

