/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class RootLoggerLevelChange
implements OperationStepHandler {
    static final String OPERATION_NAME = "change-root-log-level";
    static final RootLoggerLevelChange INSTANCE = new RootLoggerLevelChange();

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        final String level = operation.get("level").asString();
        model.get(new String[]{"root-logger", "level"}).set(level);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ServiceController controller = serviceRegistry.getService(LogServices.ROOT_LOGGER);
                    if (controller != null) {
                        ((Logger)controller.getValue()).setLevel(Level.parse((String)level));
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

