/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractLoggerService;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class RootLoggerService
extends AbstractLoggerService {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger((String)"org.jboss.as.logging");
    private Level level;
    private Handler[] saved;

    protected RootLoggerService() {
        super("");
    }

    @Override
    protected void start(StartContext context, Logger logger) throws StartException {
        logger.setLevel(this.level);
        log.info((Object)"Removing bootstrap log handlers");
        this.saved = logger.clearHandlers();
    }

    @Override
    protected void stop(StopContext context, Logger logger) {
        logger.setLevel(null);
        logger.setUseParentHandlers(true);
        logger.clearHandlers();
        for (Handler handler : this.saved) {
            logger.addHandler(handler);
        }
        log.info((Object)"Restored bootstrap log handlers");
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.setLevel(level);
        }
    }
}

