/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractDataSourceRemove
extends AbstractRemoveStepHandler {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName dataSourceServiceName;
        ServiceController dataSourceController;
        ServiceName xaDataSourceConfigServiceName;
        ServiceController xaDataSourceConfigController;
        ServiceName dataSourceConfigServiceName;
        ServiceController dataSourceConfigController;
        ServiceName referenceFactoryServiceName;
        ServiceController referenceFactoryController;
        String jndiName;
        ServiceName binderServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController binderController = registry.getService(binderServiceName = Util.getBinderServiceName(jndiName = Util.getJndiName(model)));
        if (binderController != null) {
            context.removeService(binderServiceName);
        }
        if ((referenceFactoryController = registry.getService(referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(referenceFactoryServiceName);
        }
        if ((dataSourceConfigController = registry.getService(dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(dataSourceConfigServiceName);
        }
        if ((xaDataSourceConfigController = registry.getService(xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(xaDataSourceConfigServiceName);
        }
        if ((dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(dataSourceServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }

    protected abstract AttributeDefinition[] getModelProperties();
}

