/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DataSourceEnable
implements OperationStepHandler {
    static final DataSourceEnable LOCAL_INSTANCE = new DataSourceEnable(false);
    static final DataSourceEnable XA_INSTANCE = new DataSourceEnable(true);
    private final boolean xa;
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public DataSourceEnable(boolean xa) {
        this.xa = xa;
    }

    public void execute(OperationContext context, ModelNode operation) {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        model.get("enabled").set(true);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName binderServiceName;
                    ServiceController binderController;
                    ServiceController dataSourceConfigController;
                    ServiceName dataSourceConfigServiceName;
                    String jndiName = Util.getJndiName(model);
                    ServiceRegistry registry = context.getServiceRegistry(true);
                    if (DataSourceEnable.this.isXa()) {
                        dataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                        dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
                        if (dataSourceConfigController != null) {
                            ((XaDataSource)dataSourceConfigController.getValue()).setEnabled(Boolean.valueOf(true));
                        }
                    } else {
                        dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                        dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
                        if (dataSourceConfigController != null) {
                            ((DataSource)dataSourceConfigController.getValue()).setEnabled(Boolean.valueOf(true));
                        }
                    }
                    ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceController dataSourceController = registry.getService(dataSourceServiceName);
                    if (dataSourceController != null) {
                        if (ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                            throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is already started"));
                        }
                    } else {
                        throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is not available"));
                    }
                    dataSourceController.setMode(ServiceController.Mode.ACTIVE);
                    ServiceName referenceServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceController referenceController = registry.getService(referenceServiceName);
                    if (referenceController != null && !ServiceController.State.UP.equals((Object)referenceController.getState())) {
                        referenceController.setMode(ServiceController.Mode.ACTIVE);
                    }
                    if ((binderController = registry.getService(binderServiceName = Util.getBinderServiceName(jndiName))) != null && !ServiceController.State.UP.equals((Object)binderController.getState())) {
                        binderController.setMode(ServiceController.Mode.ACTIVE);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public static DataSourceEnable getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    public boolean isXa() {
        return this.xa;
    }
}

