/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Set;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.adapters.jdbc.statistics.JdbcStatisticsPlugin;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public class LocalAndXaDataSourcesJdbcMetrics
implements OperationStepHandler {
    static LocalAndXaDataSourcesJdbcMetrics INSTANCE = new LocalAndXaDataSourcesJdbcMetrics();
    static final Set<String> ATTRIBUTES = new JdbcStatisticsPlugin().getNames();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = context.getResult();
                            if (repository.getDataSources() != null) {
                                for (DataSource ds : repository.getDataSources()) {
                                    if (!jndiName.equalsIgnoreCase(ds.getJndiName()) || ds.getStatistics() == null) continue;
                                    result.set("" + ds.getStatistics().getValue(attributeName));
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set("failed to get metrics " + e.getMessage()));
                        }
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

