/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class Util {
    public static String getJndiName(ModelNode modelNode) {
        String rawJndiName = modelNode.require("jndi-name").asString();
        String jndiName = !rawJndiName.startsWith("java:") && modelNode.hasDefined("use-java-context") && modelNode.get("use-java-context").asBoolean() ? (rawJndiName.startsWith("jboss/") ? "java:/" + rawJndiName : "java:" + rawJndiName) : rawJndiName;
        return jndiName;
    }

    public static ServiceName getBinderServiceName(String jndiName) {
        ServiceName parentContextName;
        String bindName = Util.cleanupJavaContext(jndiName);
        if (bindName.startsWith("jboss/")) {
            parentContextName = ContextNames.JBOSS_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(6);
        } else {
            parentContextName = ContextNames.JAVA_CONTEXT_SERVICE_NAME;
        }
        return parentContextName.append(new String[]{bindName});
    }

    static String cleanupJavaContext(String jndiName) {
        String bindName = jndiName.startsWith("java:/") ? jndiName.substring(6) : (jndiName.startsWith("java:") ? jndiName.substring(5) : jndiName);
        return bindName;
    }

    private Util() {
    }
}

