/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.annotation.sql.DataSourceDefinition;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.metadata.javaee.spec.IsolationLevelType;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;

public class DataSourceDefinitionProcessor
extends AbstractFinderUser
implements Processor<DataSourcesMetaData, Class<?>>,
Creator<Class<?>, DataSourceMetaData> {
    public DataSourceDefinitionProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(DataSourcesMetaData metaData, Class<?> type) {
        DataSourceDefinition annotation = this.finder.getAnnotation(type, DataSourceDefinition.class);
        if (annotation == null) {
            return;
        }
        this.process(metaData, type, annotation);
    }

    public void process(DataSourcesMetaData metaData, Class<?> type, DataSourceDefinition annotation) {
        DataSourceMetaData dataSource = this.create(type);
        metaData.add(dataSource);
    }

    @Override
    public DataSourceMetaData create(Class<?> element) {
        DataSourceDefinition dataSource = this.finder.getAnnotation(element, DataSourceDefinition.class);
        if (dataSource == null) {
            return null;
        }
        DataSourceMetaData metaData = new DataSourceMetaData();
        metaData.setName(dataSource.name());
        metaData.setClassName(dataSource.className());
        Descriptions descriptions = ProcessorUtils.getDescription(dataSource.description());
        if (descriptions != null) {
            metaData.setDescriptions(descriptions);
        }
        if (dataSource.url().length() > 0) {
            metaData.setUrl(dataSource.url());
        }
        if (dataSource.user().length() > 0) {
            metaData.setUser(dataSource.user());
        }
        if (dataSource.password().length() > 0) {
            metaData.setPassword(dataSource.password());
        }
        if (dataSource.databaseName().length() > 0) {
            metaData.setDatabaseName(dataSource.databaseName());
        }
        if (dataSource.portNumber() != -1) {
            metaData.setPortNumber(dataSource.portNumber());
        }
        if (!dataSource.serverName().equals("localhost")) {
            metaData.setServerName(dataSource.serverName());
        }
        if (dataSource.isolationLevel() != -1) {
            switch (dataSource.isolationLevel()) {
                case 0: {
                    break;
                }
                case 1: {
                    metaData.setIsolationLevel(IsolationLevelType.TRANSACTION_READ_UNCOMMITTED);
                    break;
                }
                case 2: {
                    metaData.setIsolationLevel(IsolationLevelType.TRANSACTION_READ_COMMITTED);
                    break;
                }
                case 4: {
                    metaData.setIsolationLevel(IsolationLevelType.TRANSACTION_REPEATABLE_READ);
                    break;
                }
                case 8: {
                    metaData.setIsolationLevel(IsolationLevelType.TRANSACTION_SERIALIZABLE);
                    break;
                }
            }
        }
        metaData.setTransactional(dataSource.transactional());
        if (dataSource.initialPoolSize() != -1) {
            metaData.setInitialPoolSize(dataSource.initialPoolSize());
        }
        if (dataSource.maxPoolSize() != -1) {
            metaData.setMaxPoolSize(dataSource.maxPoolSize());
        }
        if (dataSource.minPoolSize() != -1) {
            metaData.setMinPoolSize(dataSource.minPoolSize());
        }
        if (dataSource.maxIdleTime() != -1) {
            metaData.setMaxIdleTime(dataSource.maxIdleTime());
        }
        if (dataSource.maxStatements() != -1) {
            metaData.setMaxStatements(dataSource.maxStatements());
        }
        if (dataSource.properties().length > 0) {
            PropertiesMetaData properties = new PropertiesMetaData();
            for (String propertyString : dataSource.properties()) {
                int pos = propertyString.indexOf(61);
                if (pos == -1) continue;
                PropertyMetaData property = new PropertyMetaData();
                property.setName(propertyString.substring(0, pos));
                property.setValue(propertyString.substring(pos + 1));
                properties.add(property);
            }
            metaData.setProperties(properties);
        }
        if (dataSource.loginTimeout() != 0) {
            metaData.setLoginTimeout(dataSource.loginTimeout());
        }
        return metaData;
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(DataSourceDefinition.class);
    }
}

