/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.service;

import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.jacorb.ORBInitializer;
import org.jboss.as.jacorb.naming.ORBInitialContextFactory;
import org.jboss.as.jacorb.service.CorbaServiceUtil;
import org.jboss.as.jacorb.service.SecurityActions;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;

public class CorbaORBService
implements Service<ORB> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jacorb");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jacorb", "orb-service"});
    private static final Properties properties = new Properties();
    private final EnumSet<ORBInitializer> initializers;
    private final InjectedValue<SocketBinding> jacORBSocketBindingInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> jacORBSSLSocketBindingInjector = new InjectedValue();
    private ORB orb;

    public CorbaORBService(EnumSet<ORBInitializer> initializers, Properties props) {
        this.initializers = initializers;
        if (props != null) {
            properties.putAll((Map<?, ?>)props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        log.debugf("Starting Service " + context.getController().getName().getCanonicalName(), new Object[0]);
        try {
            String rootContext;
            InetSocketAddress address;
            properties.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            properties.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            SecurityActions.setSystemProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            SecurityActions.setSystemProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            if (this.jacORBSocketBindingInjector.getValue() != null) {
                address = ((SocketBinding)this.jacORBSocketBindingInjector.getValue()).getSocketAddress();
                properties.setProperty("OAIAddr", address.getHostName());
                properties.setProperty("OAPort", String.valueOf(address.getPort()));
            }
            if (this.jacORBSSLSocketBindingInjector.getValue() != null) {
                address = ((SocketBinding)this.jacORBSSLSocketBindingInjector.getValue()).getSocketAddress();
                properties.setProperty("OASSLPort", String.valueOf(address.getPort()));
                if (!properties.containsKey("OAIAddr")) {
                    properties.setProperty("OAIAddr", address.getHostName());
                }
            }
            if ((rootContext = properties.getProperty("root_context")) == null) {
                rootContext = "JBoss/Naming/root";
            }
            String host = properties.getProperty("OAIAddr");
            String port = properties.getProperty("OAPort");
            properties.setProperty("ORBInitRef.NameService", "corbaloc::" + host + ":" + port + "/" + rootContext);
            String exportCorbalocProperty = properties.getProperty("export_corbaloc", "on");
            if (exportCorbalocProperty != null && exportCorbalocProperty.equalsIgnoreCase("on")) {
                properties.setProperty("jacorb.orb.objectKeyMap.NameService", rootContext);
            }
            properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
            for (ORBInitializer initializer : this.initializers) {
                properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + initializer.getInitializerClass(), "");
            }
            ClassLoader loader = SecurityActions.getThreadContextClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader(SecurityActions.getClassLoader(this.getClass()));
                this.orb = ORB.init((String[])new String[0], (Properties)properties);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(loader);
            }
            Thread orbThread = SecurityActions.createThread(new ORBRunner(this.orb), "ORB Run Thread");
            orbThread.start();
            ORBInitialContextFactory.setORB(this.orb);
            ServiceTarget target = context.getChildTarget();
            CorbaServiceUtil.bindObject(target, "orb", this.orb);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        log.info((Object)"CORBA ORB Service Started");
    }

    public void stop(StopContext context) {
        log.debugf("Stopping Service " + context.getController().getName().getCanonicalName(), new Object[0]);
        context.asynchronous();
        Thread destroyThread = SecurityActions.createThread(new ORBDestroyer(this.orb, context), "ORB Destroy Thread");
        destroyThread.start();
    }

    public ORB getValue() throws IllegalStateException, IllegalArgumentException {
        return this.orb;
    }

    public Injector<SocketBinding> getJacORBSocketBindingInjector() {
        return this.jacORBSocketBindingInjector;
    }

    public Injector<SocketBinding> getJacORBSSLSocketBindingInjector() {
        return this.jacORBSSLSocketBindingInjector;
    }

    public static String getORBProperty(String key) {
        return properties.getProperty(key);
    }

    private class ORBDestroyer
    implements Runnable {
        private ORB orb;
        private StopContext context;

        public ORBDestroyer(ORB orb, StopContext context) {
            this.orb = orb;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.orb.destroy();
            }
            finally {
                this.context.complete();
            }
        }
    }

    private class ORBRunner
    implements Runnable {
        private ORB orb;

        public ORBRunner(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }
}

