/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.jboss.ws.common.integration.JMSDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.JMSEndpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

class JMSEndpointRegistryDeploymentAspectDelegate
extends JMSDeploymentAspect {
    private EndpointRegistry registry = null;

    JMSEndpointRegistryDeploymentAspectDelegate() {
    }

    public void start(Deployment dep) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        if (this.registry == null) {
            this.registry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        }
        Bus bus = (Bus)dep.getAttachment(Bus.class);
        Map<String, JMSConfiguration> jmsConfigMap = this.createEndpointJmsConfigMap(bus);
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            JMSEndpoint jmsEndpoint = (JMSEndpoint)endpoint;
            String endpointImplClass = jmsEndpoint.getTargetBeanName();
            JMSConfiguration jmsConfig = jmsConfigMap.get(endpointImplClass);
            if (jmsConfig != null) {
                jmsEndpoint.setTargetDestination(jmsConfig.getTargetDestination());
                jmsEndpoint.setReplyDestination(jmsConfig.getReplyDestination());
            }
            this.registry.register((Endpoint)jmsEndpoint);
        }
    }

    public void stop(Deployment dep) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        if (this.registry == null) {
            this.registry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.registry.unregister(ep);
        }
    }

    private Map<String, JMSConfiguration> createEndpointJmsConfigMap(Bus bus) {
        HashMap<String, JMSConfiguration> endpointJmsConfigMap = new HashMap<String, JMSConfiguration>();
        ServerRegistry serverRegsitry = (ServerRegistry)bus.getExtension(ServerRegistry.class);
        for (Server server : serverRegsitry.getServers()) {
            Destination destination = server.getDestination();
            if (!(destination instanceof JMSDestination)) continue;
            JMSConfiguration jmsConfiguration = ((JMSDestination)destination).getJmsConfig();
            String implClassName = this.getEndpointClassName(server);
            if (implClassName == null) continue;
            endpointJmsConfigMap.put(implClassName, jmsConfiguration);
        }
        return endpointJmsConfigMap;
    }

    private String getEndpointClassName(Server server) {
        SimpleMethodDispatcher methodDispatcher = (SimpleMethodDispatcher)server.getEndpoint().getService().get((Object)MethodDispatcher.class.getName());
        if (methodDispatcher != null && methodDispatcher instanceof SimpleMethodDispatcher) {
            Method method = methodDispatcher.getPrimaryMethod((OperationInfo)server.getEndpoint().getEndpointInfo().getInterface().getOperations().iterator().next());
            return method != null ? method.getDeclaringClass().getName() : null;
        }
        return null;
    }
}

