/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.capability.CompendiumCapability;
import org.jboss.osgi.testing.OSGiRuntime;
import org.osgi.framework.BundleException;

public class JMXCapability
extends Capability {
    private static final Logger log = Logger.getLogger(JMXCapability.class);

    public JMXCapability() {
        super(MBeanServer.class.getName());
        this.addSystemProperty("org.jboss.osgi.rmi.host", System.getProperty("jboss.bind.address", "127.0.0.1"));
        this.addSystemProperty("org.jboss.osgi.rmi.port", "1090");
        this.addDependency((Capability)new CompendiumCapability());
        this.addBundle("bundles/jboss-osgi-jmx.jar");
        this.addBundle("bundles/org.apache.aries.jmx.jar");
        this.addBundle("bundles/org.apache.aries.util.jar");
    }

    public void start(OSGiRuntime runtime) throws BundleException {
        runtime.getMBeanServer();
        super.start(runtime);
        this.assertMBeanRegistration(runtime, true);
    }

    public void stop(OSGiRuntime runtime) {
        super.stop(runtime);
        this.assertMBeanRegistration(runtime, false);
    }

    private void assertMBeanRegistration(OSGiRuntime runtime, boolean state) {
        log.debug((Object)("assertMBeanRegistration: " + state));
        MBeanServer server = (MBeanServer)runtime.getMBeanServer();
        ObjectName fwkName = ObjectNameFactory.create("osgi.core:type=framework,version=1.5");
        ObjectName bndName = ObjectNameFactory.create("osgi.core:type=bundleState,version=1.5");
        ObjectName srvName = ObjectNameFactory.create("osgi.core:type=serviceState,version=1.5");
        int timeout = 5000;
        while (0 < (timeout -= 200)) {
            boolean fwkCheck = this.checkMBean(server, fwkName, state);
            boolean bndCheck = this.checkMBean(server, bndName, state);
            boolean srvCheck = this.checkMBean(server, srvName, state);
            if (fwkCheck && bndCheck && srvCheck) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        if (!this.checkMBean(server, fwkName, state)) {
            log.warn((Object)("FrameworkMBean " + (state ? "not" : "still") + " registered"));
        }
        if (!this.checkMBean(server, bndName, state)) {
            log.warn((Object)("BundleStateMBean " + (state ? "not" : "still") + " registered"));
        }
        if (!this.checkMBean(server, srvName, state)) {
            log.warn((Object)("ServiceStateMBean " + (state ? "not" : "still") + " registered"));
        }
    }

    protected boolean checkMBean(MBeanServer server, ObjectName oname, boolean state) {
        boolean registered = server.isRegistered(oname);
        log.debug((Object)(oname + " registered: " + registered));
        return registered == state;
    }
}

