/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MBeanServerService {
    private static final Logger log = Logger.getLogger(MBeanServerService.class);
    private BundleContext context;

    public MBeanServerService(BundleContext context) {
        this.context = context;
    }

    public MBeanServer registerMBeanServer() {
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            MBeanServer mbeanServer = (MBeanServer)this.context.getService(sref);
            log.debug((Object)("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain()));
            return mbeanServer;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        this.context.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
        log.debug((Object)"MBeanServer registered");
        return mbeanServer;
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warn((Object)("Multiple MBeanServer instances: " + serverArr));
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.debug((Object)("Found MBeanServer: " + mbeanServer));
        }
        if (mbeanServer == null) {
            log.debug((Object)"No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
            log.debug((Object)("Created MBeanServer: " + mbeanServer));
        }
        return mbeanServer;
    }
}

