/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;

public class ConsoleHandler
implements ManagementHttpHandler {
    public static final String CONTEXT = "/console";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String NOCACHE_JS = ".nocache.js";
    private static final String WILDCARD = "*";
    private static final String DATEFORMAT_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String GMT = "GMT";
    private ClassLoader loader = null;
    private static Map<String, String> contentTypeMapping = new ConcurrentHashMap<String, String>();
    private long lastExpiryDate = 0L;
    private String lastExpiryHeader = null;

    public ConsoleHandler() {
    }

    public ConsoleHandler(ClassLoader loader) {
        this.loader = loader;
    }

    public void handle(HttpExchange http) throws IOException {
        InputStream inputStream;
        URI uri = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        if (!"GET".equals(requestMethod)) {
            http.sendResponseHeaders(405, -1L);
            return;
        }
        String path = uri.getPath();
        String resource = path.substring(CONTEXT.length(), path.length());
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if (resource.equals("")) {
            InetSocketAddress address = http.getHttpContext().getServer().getAddress();
            String hostName = address.getHostName();
            int port = address.getPort();
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Content-Type", "text/html");
            responseHeaders.add("Location", "http://" + hostName + ":" + port + "/console/index.html");
            http.sendResponseHeaders(302, 0L);
            OutputStream outputStream = http.getResponseBody();
            outputStream.flush();
            ConsoleHandler.safeClose(outputStream);
            return;
        }
        if (resource.indexOf(".") == -1) {
            this.respond404(http);
        }
        if ((inputStream = this.getLoader().getResourceAsStream(resource)) != null) {
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Content-Type", this.resolveContentType(path));
            responseHeaders.add("Access-Control-Allow-Origin", WILDCARD);
            boolean skipcache = resource.endsWith(NOCACHE_JS);
            if (!skipcache) {
                if (System.currentTimeMillis() > this.lastExpiryDate) {
                    this.lastExpiryDate = ConsoleHandler.calculateExpiryDate();
                    this.lastExpiryHeader = ConsoleHandler.htmlExpiresDateFormat().format(new Date(this.lastExpiryDate));
                }
                responseHeaders.add(EXPIRES_HEADER, this.lastExpiryHeader);
            }
            http.sendResponseHeaders(200, 0L);
            OutputStream outputStream = http.getResponseBody();
            ConsoleHandler.fastChannelCopy(inputStream, outputStream);
            outputStream.flush();
            ConsoleHandler.safeClose(outputStream);
            ConsoleHandler.safeClose(inputStream);
        } else {
            this.respond404(http);
        }
    }

    private static long calculateExpiryDate() {
        Calendar cal = Calendar.getInstance();
        cal.roll(2, 1);
        return cal.getTime().getTime();
    }

    public static DateFormat htmlExpiresDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat(DATEFORMAT_FORMAT, Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
        return httpDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fastChannelCopy(InputStream in, OutputStream out) throws IOException {
        ReadableByteChannel src = Channels.newChannel(in);
        WritableByteChannel dest = Channels.newChannel(out);
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        finally {
            ConsoleHandler.safeClose(src);
            ConsoleHandler.safeClose(dest);
        }
    }

    private static void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String resolveContentType(String resource) {
        assert (resource.indexOf(".") != -1) : "Invalid resource";
        String contentType = null;
        for (String suffix : contentTypeMapping.keySet()) {
            if (!resource.endsWith(suffix)) continue;
            contentType = contentTypeMapping.get(suffix);
            break;
        }
        if (null == contentType) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private void respond404(HttpExchange http) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", "text/html");
        responseHeaders.add("Access-Control-Allow-Origin", WILDCARD);
        http.sendResponseHeaders(404, 0L);
        OutputStream out = http.getResponseBody();
        out.flush();
        ConsoleHandler.safeClose(out);
    }

    private ClassLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return ConsoleHandler.class.getClassLoader();
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext(CONTEXT, (HttpHandler)this);
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext(CONTEXT);
    }

    static {
        contentTypeMapping.put(".js", "application/javascript");
        contentTypeMapping.put(".html", "text/html");
        contentTypeMapping.put(".htm", "text/html");
        contentTypeMapping.put(".css", "text/css");
        contentTypeMapping.put(".gif", "image/gif");
        contentTypeMapping.put(".png", "image/png");
        contentTypeMapping.put(".jpeg", "image/jpeg");
    }
}

