/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.MessagingSubsystemAdd;
import org.jboss.as.messaging.MessagingSubsystemDescribeHandler;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryRemove;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    private static final PathElement CFS_PATH = PathElement.pathElement((String)"connection-factory");
    private static final PathElement JMS_QUEUE_PATH = PathElement.pathElement((String)"jms-queue");
    private static final PathElement TOPIC_PATH = PathElement.pathElement((String)"jms-topic");
    private static final PathElement RA_PATH = PathElement.pathElement((String)"pooled-connection-factory");

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(MessagingSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)MessagingSubsystemAdd.INSTANCE, MessagingSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)MessagingSubsystemDescribeHandler.INSTANCE, MessagingSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingSubsystemParser.getInstance());
        ManagementResourceRegistration queue = registration.registerSubModel(PathElement.pathElement((String)"queue"), MessagingSubsystemProviders.QUEUE_RESOURCE);
        queue.registerOperationHandler("add", (OperationStepHandler)QueueAdd.INSTANCE, (DescriptionProvider)QueueAdd.INSTANCE, false);
        queue.registerOperationHandler("remove", (OperationStepHandler)QueueRemove.INSTANCE, (DescriptionProvider)QueueRemove.INSTANCE, false);
        ManagementResourceRegistration cfs = registration.registerSubModel(CFS_PATH, MessagingSubsystemProviders.CF);
        cfs.registerOperationHandler("add", (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.CF_ADD, false);
        cfs.registerOperationHandler("remove", (OperationStepHandler)ConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.CF_REMOVE, false);
        ManagementResourceRegistration queues = registration.registerSubModel(JMS_QUEUE_PATH, MessagingSubsystemProviders.JMS_QUEUE_RESOURCE);
        queues.registerOperationHandler("add", (OperationStepHandler)JMSQueueAdd.INSTANCE, MessagingSubsystemProviders.JMS_QUEUE_ADD, false);
        queues.registerOperationHandler("remove", (OperationStepHandler)JMSQueueRemove.INSTANCE, MessagingSubsystemProviders.JMS_QUEUE_REMOVE, false);
        ManagementResourceRegistration topics = registration.registerSubModel(TOPIC_PATH, MessagingSubsystemProviders.JMS_TOPIC_RESOURCE);
        topics.registerOperationHandler("add", (OperationStepHandler)JMSTopicAdd.INSTANCE, MessagingSubsystemProviders.JMS_TOPIC_ADD, false);
        topics.registerOperationHandler("remove", (OperationStepHandler)JMSTopicRemove.INSTANCE, MessagingSubsystemProviders.JMS_TOPIC_REMOVE, false);
        ManagementResourceRegistration resourceAdapters = registration.registerSubModel(RA_PATH, MessagingSubsystemProviders.RA);
        resourceAdapters.registerOperationHandler("add", (OperationStepHandler)PooledConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.RA_ADD, false);
        resourceAdapters.registerOperationHandler("remove", (OperationStepHandler)PooledConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.RA_REMOVE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.MESSAGING_1_0.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
    }
}

