/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQServer;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class QueueService
implements Service<Void> {
    private final InjectedValue<HornetQServer> hornetQService = new InjectedValue();
    private final String address;
    private final String queueName;
    private final String filter;
    private final boolean durable;
    private final boolean temporary;

    public QueueService(String address, String queueName, String filter, boolean durable, boolean temporary) {
        if (queueName == null) {
            throw new IllegalArgumentException("null queue name");
        }
        this.address = address != null ? address : queueName;
        this.queueName = queueName;
        this.filter = filter;
        this.durable = durable;
        this.temporary = temporary;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            HornetQServer hornetQService = (HornetQServer)this.hornetQService.getValue();
            hornetQService.deployQueue(new SimpleString(this.address), new SimpleString(this.queueName), this.filter != null ? new SimpleString(this.filter) : null, this.durable, this.temporary);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            HornetQServer hornetQService = (HornetQServer)this.hornetQService.getValue();
            hornetQService.destroyQueue(new SimpleString(this.queueName), null);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy queue (%s)", (Object)this.queueName);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<HornetQServer> getHornetQService() {
        return this.hornetQService;
    }
}

