/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ConnectionFactoryAdd INSTANCE = new ConnectionFactoryAdd();
    private static final String[] NO_BINDINGS = new String[0];

    protected void populateModel(ModelNode operation, ModelNode model) {
        for (JMSServices.NodeAttribute attribute : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attribute.getName();
            if (!operation.hasDefined(attrName)) continue;
            model.get(attrName).set(operation.get(attrName));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ConnectionFactoryConfiguration configuration = ConnectionFactoryAdd.createConfiguration(name, operation);
        ConnectionFactoryService service = new ConnectionFactoryService(configuration);
        ServiceName serviceName = JMSServices.JMS_CF_BASE.append(new String[]{name});
        newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static ConnectionFactoryConfiguration createConfiguration(String name, ModelNode operation) {
        ConnectionFactoryConfigurationImpl config = new ConnectionFactoryConfigurationImpl(name, false, ConnectionFactoryAdd.jndiBindings(operation));
        config.setHA(operation.get("ha").asBoolean(false));
        config.setAutoGroup(operation.get("auto-group").asBoolean(false));
        config.setBlockOnAcknowledge(operation.get("block-on-acknowledge").asBoolean(false));
        config.setBlockOnDurableSend(operation.get("block-on-durable-send").asBoolean(true));
        config.setBlockOnNonDurableSend(operation.get("block-on-non-durable-send").asBoolean(false));
        config.setCacheLargeMessagesClient(operation.get("cache-large-message-client").asBoolean(false));
        config.setCallTimeout(operation.get("call-timeout").asLong(30000L));
        config.setClientFailureCheckPeriod((long)operation.get("client-failure-check-period").asInt(30000));
        if (operation.hasDefined("client-id")) {
            config.setClientID(operation.get("client-id").asString());
        }
        config.setConfirmationWindowSize(operation.get("confirmation-window-size").asInt(-1));
        config.setConnectionTTL(operation.get("connection-ttl").asLong(60000L));
        if (operation.hasDefined("connector")) {
            ModelNode connectorRefs = operation.get("connector");
            ArrayList<String> connectorNames = new ArrayList<String>();
            for (String connectorName : operation.get("connector").keys()) {
                ModelNode connectorRef = connectorRefs.get(connectorName);
                connectorNames.add(connectorName);
            }
            config.setConnectorNames(connectorNames);
        }
        config.setConsumerMaxRate(operation.get("consumer-max-rate").asInt(-1));
        config.setConsumerWindowSize(operation.get("consumer-window-size").asInt(0x100000));
        if (operation.hasDefined("discovery-group-name")) {
            config.setDiscoveryGroupName(operation.get("discovery-group-name").asString());
        }
        config.setDupsOKBatchSize(operation.get("dups-ok-batch-size").asInt(0x100000));
        config.setFailoverOnInitialConnection(operation.get("failover-on-initial-connection").asBoolean(false));
        if (operation.hasDefined("group-id")) {
            config.setGroupID(operation.get("group-id").asString());
        }
        if (operation.hasDefined("connection-load-balancing-policy-class-name")) {
            config.setLoadBalancingPolicyClassName(operation.get("connection-load-balancing-policy-class-name").asString());
        }
        config.setMaxRetryInterval(operation.get("max-retry-interval").asLong(2000L));
        config.setMinLargeMessageSize(operation.get("min-large-message-size").asInt(102400));
        config.setPreAcknowledge(operation.get("pre-acknowledge").asBoolean(false));
        config.setProducerMaxRate(operation.get("producer-max-rate").asInt(-1));
        config.setProducerWindowSize(operation.get("producer-window-size").asInt(65536));
        config.setReconnectAttempts(operation.get("reconnect-attempts").asInt(0));
        config.setRetryInterval(operation.get("retry-interval").asLong(2000L));
        config.setRetryIntervalMultiplier(operation.get("retry-interval-multiplier").asDouble(1.0));
        config.setScheduledThreadPoolMaxSize(operation.get("scheduled-thread-pool-max-size").asInt(5));
        config.setThreadPoolMaxSize(operation.get("thread-pool-max-size").asInt(-1));
        config.setTransactionBatchSize(operation.get("transaction-batch-size").asInt(0x100000));
        config.setUseGlobalPools(operation.get("use-global-pools").asBoolean(true));
        return config;
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (JMSServices.NodeAttribute attribute : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attribute.getName();
            if (!subModel.has(attrName)) continue;
            operation.get(attrName).set(subModel.get(attrName));
        }
        return operation;
    }
}

