/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public abstract class AbstractCommonConfig
implements CommonConfig {
    private String configName;
    private Map<String, Feature> features = new HashMap<String, Feature>();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<UnifiedHandlerChainMetaData> preHandlerChains;
    private List<UnifiedHandlerChainMetaData> postHandlerChains;

    @Override
    public List<UnifiedHandlerChainMetaData> getPostHandlerChains() {
        return this.postHandlerChains;
    }

    @Override
    public void setPostHandlerChains(List<UnifiedHandlerChainMetaData> postHandlerChain) {
        this.postHandlerChains = postHandlerChain;
    }

    @Override
    public List<UnifiedHandlerChainMetaData> getPreHandlerChains() {
        return this.preHandlerChains;
    }

    @Override
    public void setPreHandlerChains(List<UnifiedHandlerChainMetaData> preHandlerChains) {
        this.preHandlerChains = preHandlerChains;
    }

    @Override
    public List<UnifiedHandlerChainMetaData> getHandlers(UnifiedHandlerMetaData.HandlerType type) {
        List<UnifiedHandlerChainMetaData> handlerChains;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChains = this.getPreHandlerChains();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChains = this.getPostHandlerChains();
        } else {
            throw new IllegalArgumentException("Invalid handler type: " + (Object)((Object)type));
        }
        return handlerChains;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public boolean hasFeature(String name) {
        return this.features.containsKey(name);
    }

    @Override
    public void setFeature(Feature feature, boolean enabled) {
        if (enabled) {
            this.features.put(feature.getName(), feature);
        } else {
            this.features.remove(feature.getName());
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

