/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.util;

import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXUtils {
    private static final BlockingQueue<XMLInputFactory> INPUT_FACTORY_POOL;

    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", nsAware);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Reading external entities is disabled");
            }
        });
        return factory;
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory f = (XMLInputFactory)INPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = StAXUtils.createXMLInputFactory(true);
        }
        return f;
    }

    private static void returnXMLInputFactory(XMLInputFactory factory) {
        INPUT_FACTORY_POOL.offer(factory);
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) {
        XMLInputFactory factory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(in);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        finally {
            StAXUtils.returnXMLInputFactory(factory);
        }
    }

    public static boolean match(XMLStreamReader reader, QName name) {
        return reader.getName().equals(name);
    }

    public static boolean match(XMLStreamReader reader, String namespace, String localName) {
        QName name = reader.getName();
        return localName.equals(name.getLocalPart()) && namespace.equals(name.getNamespaceURI());
    }

    public static String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        return elementtext == null ? null : elementtext.trim();
    }

    public static QName elementAsQName(XMLStreamReader reader) throws XMLStreamException {
        String text = StAXUtils.elementAsString(reader);
        return StAXUtils.stringToQName(reader, text, reader.getNamespaceURI());
    }

    public static boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException {
        String text = StAXUtils.elementAsString(reader);
        return Boolean.parseBoolean(text);
    }

    public static int elementAsInt(XMLStreamReader reader) throws XMLStreamException {
        String text = StAXUtils.elementAsString(reader);
        return Integer.parseInt(text);
    }

    public static QName attributeAsQName(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String text = reader.getAttributeValue(namespace, localName);
        return StAXUtils.stringToQName(reader, text, reader.getNamespaceURI());
    }

    public static QName attributeAsQName(XMLStreamReader reader, String namespace, String localName, String targetNS) throws XMLStreamException {
        String text = reader.getAttributeValue(namespace, localName);
        return StAXUtils.stringToQName(reader, text, targetNS);
    }

    private static QName stringToQName(XMLStreamReader reader, String text, String defaultNS) {
        String localPart = text.substring(text.indexOf(58) + 1, text.length());
        int i = text.indexOf(58);
        String prefix = i < 0 ? null : text.substring(0, i);
        String namespaceURI = prefix == null ? defaultNS : reader.getNamespaceURI(prefix);
        return prefix == null ? new QName(namespaceURI, localPart) : new QName(namespaceURI, localPart, prefix);
    }

    public static int nextElement(XMLStreamReader reader) {
        try {
            int x = reader.next();
            while (x != 1 && x != 2 && reader.hasNext()) {
                x = reader.next();
            }
            return x;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    static {
        int i = 10;
        try {
            String s = System.getProperty("org.jboss.ws.staxutils.pool-size", "10");
            i = Integer.parseInt(s);
        }
        catch (Throwable t) {
            i = 10;
        }
        if (i <= 0) {
            i = 10;
        }
        INPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLInputFactory>(i);
    }
}

