/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.cache.grouped.PassivationGroup;
import org.jboss.ejb3.cache.impl.GroupedPassivatingCacheImpl;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class PassivationGroupImpl
implements PassivationGroup {
    private static final Logger log = Logger.getLogger(PassivationGroupImpl.class);
    private static final long serialVersionUID = 1L;
    private final Serializable id = new GUID();
    private final Map<Object, Object> members = new HashMap<Object, Object>();
    private final transient Map<Object, GroupedPassivatingCacheImpl.Entry> active = new HashMap<Object, GroupedPassivatingCacheImpl.Entry>();

    void addMember(Object key, GroupedPassivatingCacheImpl.Entry entry) {
        log.trace((Object)("add member " + key + ", " + entry));
        this.members.put(key, entry.obj);
        this.active.put(key, entry);
    }

    public Serializable getId() {
        return this.id;
    }

    Object getMember(Object key) {
        return this.members.get(key);
    }

    void postActivate() {
    }

    void prePassivate() {
        for (GroupedPassivatingCacheImpl.Entry entry : this.active.values()) {
            entry.passivate();
        }
        this.active.clear();
    }

    void removeActive(Object key) {
        this.active.remove(key);
    }
}

