/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.encoded.SoapArrayType;
import org.apache.cxf.aegis.type.encoded.SoapEncodingUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeInfo {
    private static final String SOAP_ENCODING_NS_1_1 = Soap11.getInstance().getSoapEncodingStyle();
    private static final QName SOAP_ARRAY_TYPE = new QName(SOAP_ENCODING_NS_1_1, "arrayType");
    private static final QName SOAP_ARRAY_OFFSET = new QName(SOAP_ENCODING_NS_1_1, "offset");
    private AegisType type;
    private QName typeName;
    private int ranks;
    private final List<Integer> dimensions = new ArrayList<Integer>();
    private int offset;

    public ArrayTypeInfo(QName typeName, int ranks, Integer ... dimensions) {
        this.typeName = typeName;
        this.ranks = ranks;
        this.dimensions.addAll(Arrays.asList(dimensions));
    }

    public ArrayTypeInfo(MessageReader reader, TypeMapping tm) {
        this(reader.getXMLStreamReader().getNamespaceContext(), SoapEncodingUtil.readAttributeValue(reader, SOAP_ARRAY_TYPE), SoapEncodingUtil.readAttributeValue(reader, SOAP_ARRAY_OFFSET));
        String namespace = reader.getNamespaceForPrefix(this.typeName.getPrefix());
        if (!StringUtils.isEmpty((String)namespace)) {
            this.typeName = "http://www.w3.org/2001/XMLSchema".equals(namespace) && "ur-type".equals(this.typeName.getLocalPart()) ? new QName(namespace, "anyType", this.typeName.getPrefix()) : new QName(namespace, this.typeName.getLocalPart(), this.typeName.getPrefix());
        }
        if (tm != null) {
            this.type = tm.getType(this.typeName);
            if (this.ranks > 0) {
                Class<?> componentType = this.type.getTypeClass();
                for (int i = 1; i < this.ranks + this.dimensions.size(); ++i) {
                    componentType = Array.newInstance(componentType, 0).getClass();
                }
                SoapArrayType arrayType = new SoapArrayType();
                arrayType.setTypeClass(componentType);
                arrayType.setTypeMapping(this.type.getTypeMapping());
                this.type = arrayType;
            }
        }
    }

    public ArrayTypeInfo(NamespaceContext namespaceContext, String arrayTypeValue) {
        this(namespaceContext, arrayTypeValue, null);
    }

    public ArrayTypeInfo(NamespaceContext namespaceContext, String arrayTypeValue, String offsetString) {
        if (arrayTypeValue == null) {
            throw new NullPointerException("arrayTypeValue is null");
        }
        StringTokenizer tokenizer = new StringTokenizer(arrayTypeValue, "[],:", true);
        List tokens = CastUtils.cast(Collections.list(tokenizer));
        if (tokens.size() < 3) {
            throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
        }
        if (((String)tokens.get(1)).equals(":")) {
            this.typeName = new QName(namespaceContext.getNamespaceURI((String)tokens.get(0)), (String)tokens.get(2), (String)tokens.get(0));
            tokens = tokens.subList(3, tokens.size());
        } else {
            this.typeName = new QName("", (String)tokens.get(0));
            tokens = tokens.subList(1, tokens.size());
        }
        if (!((String)tokens.get(0)).equals("[")) {
            throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
        }
        boolean hasRank = tokens.subList(1, tokens.size()).contains("[");
        if (hasRank) {
            this.ranks = 1;
            for (String token : tokens.subList(1, tokens.size())) {
                if ("]".equals(token)) {
                    if (tokens.size() < this.ranks + 1) {
                        throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
                    }
                    tokens = tokens.subList(this.ranks + 1, tokens.size());
                    break;
                }
                if (",".equals(token)) {
                    ++this.ranks;
                    continue;
                }
                throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
            }
        }
        for (int i = 1; i < tokens.size(); i += 2) {
            int value;
            String dimension = (String)tokens.get(i);
            if ("]".equals(dimension)) {
                if (i + 1 == tokens.size()) break;
                throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
            }
            try {
                value = Integer.parseInt(dimension);
            }
            catch (NumberFormatException e) {
                throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
            }
            if (value < 1) {
                throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
            }
            this.dimensions.add(value);
            String next = (String)tokens.get(i + 1);
            if (",".equals(next) || "]".equals(next)) continue;
            throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
        }
        if (this.dimensions.isEmpty()) {
            throw new DatabindingException("Invalid ArrayType value " + arrayTypeValue);
        }
        if (offsetString != null) {
            tokens = CastUtils.cast(Collections.list(new StringTokenizer(offsetString, "[]", true)));
            if (tokens.size() != 3 || !"[".equals(tokens.get(0)) || !"]".equals(tokens.get(2))) {
                throw new DatabindingException("Invalid Array offset value " + offsetString);
            }
            try {
                this.offset = Integer.parseInt((String)tokens.get(1));
            }
            catch (NumberFormatException e) {
                throw new DatabindingException("Invalid Array offset value " + offsetString);
            }
        }
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public AegisType getType() {
        return this.type;
    }

    public int getRanks() {
        return this.ranks;
    }

    public List<Integer> getDimensions() {
        return this.dimensions;
    }

    public int getTotalDimensions() {
        return this.ranks + this.dimensions.size();
    }

    public int getOffset() {
        return this.offset;
    }

    public void writeAttribute(MessageWriter writer) {
        String value = this.toString();
        SoapEncodingUtil.writeAttribute(writer, SOAP_ARRAY_TYPE, value);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        if ("".equals(this.typeName.getPrefix()) && !"".equals(this.typeName.getNamespaceURI())) {
            throw new RuntimeException("No prefix provided in QName for " + this.typeName.getNamespaceURI());
        }
        if (this.typeName.getPrefix() != null && this.typeName.getPrefix().length() > 0) {
            string.append(this.typeName.getPrefix()).append(":");
        }
        string.append(this.typeName.getLocalPart());
        if (this.ranks > 0) {
            string.append("[");
            for (int i = 1; i < this.ranks; ++i) {
                string.append(",");
            }
            string.append("]");
        }
        string.append("[");
        string.append(this.dimensions.get(0));
        for (int dimension : this.dimensions.subList(1, this.dimensions.size())) {
            string.append(",").append(dimension);
        }
        string.append("]");
        return string.toString();
    }
}

