/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx2.impl;

import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.logging.Logger;

public abstract class BMTInterceptor {
    private static final Logger log = Logger.getLogger(BMTInterceptor.class);

    protected abstract TransactionalComponent getTransactionalComponent();

    protected abstract Object handleInvocation(InvocationContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object invoke(InvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction oldTx = tm.suspend();
        try {
            Object object = this.handleInvocation(invocation);
            return object;
        }
        finally {
            if (oldTx != null) {
                tm.resume(oldTx);
            }
        }
    }

    protected abstract TransactionManager getTransactionManager();

    protected void handleException(Exception ex) throws Exception {
        if (ex == null) {
            return;
        }
        ApplicationException ae = this.getTransactionalComponent().getApplicationException(ex.getClass());
        if (ae != null) {
            throw ex;
        }
        if (ex instanceof EJBException) {
            throw (EJBException)ex;
        }
        throw new EJBException(ex);
    }
}

