/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SnapshotDescriptions {
    private static final String RESOURCE_NAME = InterfaceDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getSnapshotTakeModel(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation").set("take-snapshot");
        node.get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.take.description"));
        node.get("reply-properties").get("name").get("type").set(ModelType.STRING);
        node.get("reply-properties").get("name").get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.take.reply.name"));
        return node;
    }

    public static ModelNode getSnapshotListModel(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation").set("list-snapshots");
        node.get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.list.description"));
        node.get("reply-properties").get("directory").get("type").set(ModelType.STRING);
        node.get("reply-properties").get("directory").get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.list.reply.dir"));
        node.get("reply-properties").get("names").get("type").set(ModelType.LIST);
        node.get("reply-properties").get("names").get("value-type").set(ModelType.STRING);
        node.get("reply-properties").get("names").get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.list.reply.names"));
        return node;
    }

    public static ModelNode getSnapshotDeleteModel(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation").set("delete-snapshot");
        node.get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.delete.description"));
        node.get("reply-properties").get("name").get("type").set(ModelType.STRING);
        node.get("reply-properties").get("name").get("required").set(true);
        node.get("reply-properties").get("name").get("description").set(SnapshotDescriptions.getResourceBundle(locale).getString("snapshot.delete.name"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

