/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingGroupDescription {
    private static final String RESOURCE_NAME = SocketBindingGroupDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getServerSocketBindingGroupDescription(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = SocketBindingGroupDescription.getGroupDescription(bundle.getString("socket_binding_group"), bundle);
        root.get(new String[]{"attributes", "port-offset", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "port-offset", "description"}).set(bundle.getString("server_socket_binding_group.port-offset"));
        root.get(new String[]{"attributes", "port-offset", "required"}).set(false);
        root.get(new String[]{"attributes", "port-offset", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "port-offset", "tail-comment-allowed"}).set(false);
        return root;
    }

    public static ModelNode getDomainSocketBindingGroupDescription(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = SocketBindingGroupDescription.getGroupDescription(bundle.getString("socket_binding_group"), bundle);
        root.get(new String[]{"attributes", "includes", "type"}).set(ModelType.LIST);
        root.get(new String[]{"attributes", "includes", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "includes", "description"}).set(bundle.getString("domain_socket_binding_group.includes"));
        root.get(new String[]{"attributes", "includes", "required"}).set(false);
        root.get(new String[]{"attributes", "includes", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "includes", "tail-comment-allowed"}).set(false);
        return root;
    }

    private static ModelNode getGroupDescription(String description, ResourceBundle bundle) {
        ModelNode root = new ModelNode();
        root.get("description").set(description);
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("socket_binding_group.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "name", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "default-interface", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "default-interface", "description"}).set(bundle.getString("socket_binding_group.default-interface"));
        root.get(new String[]{"attributes", "default-interface", "required"}).set(true);
        root.get(new String[]{"attributes", "default-interface", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "default-interface", "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "socket-binding", "description"}).set(bundle.getString("socket_binding_group.socket-binding"));
        root.get(new String[]{"children", "socket-binding", "min-occurs"}).set(0);
        root.get(new String[]{"children", "socket-binding", "model-description"});
        return root;
    }

    public static ModelNode getServerSocketBindingGroupAddOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = SocketBindingGroupDescription.getSocketBindingGroupAdd(bundle.getString("server_socket_binding_group.add"), bundle);
        root.get(new String[]{"request-properties", "port-offset", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "port-offset", "description"}).set(bundle.getString("server-socket_binding_group.add.port-offset"));
        root.get(new String[]{"request-properties", "port-offset", "required"}).set(false);
        return root;
    }

    public static ModelNode getDomainSocketBindingGroupAddOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = SocketBindingGroupDescription.getSocketBindingGroupAdd(bundle.getString("domain_socket_binding_group.add"), bundle);
        root.get(new String[]{"request-properties", "includes", "type"}).set(ModelType.LIST);
        root.get(new String[]{"request-properties", "includes", "value-type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "includes", "description"}).set(bundle.getString("domain-socket_binding_group.add.includes"));
        root.get(new String[]{"request-properties", "includes", "required"}).set(false);
        return root;
    }

    private static ModelNode getSocketBindingGroupAdd(String description, ResourceBundle bundle) {
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(description);
        root.get(new String[]{"request-properties", "default-interface", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "default-interface", "description"}).set(bundle.getString("socket_binding_group.add.default-interface"));
        root.get(new String[]{"request-properties", "default-interface", "required"}).set(true);
        root.get(new String[]{"request-properties", "default-interface", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "default-interface", "nillable"}).set(false);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSocketBindingGroupRemoveOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("socket_binding_group.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getAddSocketBindingGroupIncludeOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-include");
        root.get("description").set(bundle.getString("domain_socket_binding_group.include.add"));
        root.get(new String[]{"request-properties", "include", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "include", "description"}).set(bundle.getString("domain_socket_binding_group.include.add.include"));
        root.get(new String[]{"request-properties", "include", "required"}).set(true);
        root.get(new String[]{"request-properties", "include", "min-length"}).set(1);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveSocketBindingGroupIncludeOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-included-group");
        root.get("description").set(bundle.getString("domain_socket_binding_group.include.remove"));
        root.get(new String[]{"request-properties", "include", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "include", "description"}).set(bundle.getString("domain_socket_binding_group.include.remove.include"));
        root.get(new String[]{"request-properties", "include", "required"}).set(true);
        root.get(new String[]{"request-properties", "include", "min-length"}).set(1);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSocketBindingDescription(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("socket_binding"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("socket_binding.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "name", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "interface", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "interface", "description"}).set(bundle.getString("socket_binding.interface"));
        root.get(new String[]{"attributes", "interface", "required"}).set(false);
        root.get(new String[]{"attributes", "interface", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "interface", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "port", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "port", "description"}).set(bundle.getString("socket_binding.port"));
        root.get(new String[]{"attributes", "port", "required"}).set(true);
        root.get(new String[]{"attributes", "port", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "port", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "fixed-port", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "fixed-port", "description"}).set(bundle.getString("socket_binding.fixed-port"));
        root.get(new String[]{"attributes", "fixed-port", "required"}).set(true);
        root.get(new String[]{"attributes", "fixed-port", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "fixed-port", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "multicast-address", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "multicast-address", "description"}).set(bundle.getString("socket_binding.multicast-address"));
        root.get(new String[]{"attributes", "multicast-address", "required"}).set(false);
        root.get(new String[]{"attributes", "multicast-address", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "multicast-address", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "multicast-port", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "multicast-port", "description"}).set(bundle.getString("socket_binding.multicast-port"));
        root.get(new String[]{"attributes", "multicast-port", "required"}).set(false);
        root.get(new String[]{"attributes", "multicast-port", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "multicast-port", "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getSocketBindingAddOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("socket-binding.add"));
        root.get(new String[]{"request-properties", "interface", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "interface", "description"}).set(bundle.getString("socket_binding.add.interface"));
        root.get(new String[]{"request-properties", "interface", "required"}).set(false);
        root.get(new String[]{"request-properties", "interface", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "interface", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "port", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "port", "description"}).set(bundle.getString("socket_binding.add.port"));
        root.get(new String[]{"request-properties", "port", "required"}).set(true);
        root.get(new String[]{"request-properties", "port", "min"}).set(0);
        root.get(new String[]{"request-properties", "port", "max"}).set(65535);
        root.get(new String[]{"request-properties", "fixed-port", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "fixed-port", "description"}).set(bundle.getString("socket_binding.add.fixed-port"));
        root.get(new String[]{"request-properties", "fixed-port", "required"}).set(false);
        root.get(new String[]{"request-properties", "multicast-address", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "multicast-address", "description"}).set(bundle.getString("socket_binding.add.multicast-address"));
        root.get(new String[]{"request-properties", "multicast-address", "required"}).set(false);
        root.get(new String[]{"request-properties", "multicast-address", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "multicast-address", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "multicast-port", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "multicast-port", "description"}).set(bundle.getString("socket_binding.add.multicast-port"));
        root.get(new String[]{"request-properties", "multicast-port", "required"}).set(false);
        root.get(new String[]{"request-properties", "multicast-port", "min"}).set(1);
        root.get(new String[]{"request-properties", "multicast-port", "max"}).set(65535);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSocketBindingRemoveOperation(Locale locale) {
        ResourceBundle bundle = SocketBindingGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("socket_binding.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        ModelNode binding = SocketBindingGroupDescription.getSocketBindingDescription(null);
        binding.get(new String[]{"operations", "add"}).set(SocketBindingGroupDescription.getSocketBindingAddOperation(null));
        binding.get(new String[]{"operations", "remove"}).set(SocketBindingGroupDescription.getSocketBindingRemoveOperation(null));
        ModelNode node = SocketBindingGroupDescription.getServerSocketBindingGroupDescription(null);
        node.get(new String[]{"operations", "add"}).set(SocketBindingGroupDescription.getServerSocketBindingGroupAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(SocketBindingGroupDescription.getSocketBindingGroupRemoveOperation(null));
        node.get(new String[]{"children", "socket-binding", "model-description"}).set(binding);
        System.out.println(node);
        node = SocketBindingGroupDescription.getDomainSocketBindingGroupDescription(null);
        node.get(new String[]{"operations", "add"}).set(SocketBindingGroupDescription.getDomainSocketBindingGroupAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(SocketBindingGroupDescription.getSocketBindingGroupRemoveOperation(null));
        node.get(new String[]{"children", "socket-binding", "model-description"}).set(binding);
        System.out.println(node);
    }
}

