/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    AGENT_LIB("agent-lib"),
    AGENT_PATH("agent-path"),
    ANY("any"),
    ANY_ADDRESS("any-address"),
    ANY_IPV4_ADDRESS("any-ipv4-address"),
    ANY_IPV6_ADDRESS("any-ipv6-address"),
    AUTHENTICATION("authentication"),
    CONTENT("content"),
    DOMAIN("domain"),
    DOMAIN_CONTROLLER("domain-controller"),
    DEPLOYMENT("deployment"),
    DEPLOYMENTS("deployments"),
    DEPLOYMENT_REPOSITORY("deployment-repository"),
    ENVIRONMENT_VARIABLES("environment-variables"),
    EXTENSION("extension"),
    EXTENSIONS("extensions"),
    FS_ARCHIVE("fs-archive"),
    FS_EXPLODED("fs-exploded"),
    HEAP("heap"),
    HOST("host"),
    HTTP_INTERFACE("http-interface"),
    INCLUDE("include"),
    INET_ADDRESS("inet-address"),
    INTERFACE("interface"),
    INTERFACE_SPECS("interface-specs"),
    INTERFACES("interfaces"),
    JAVA_AGENT("java-agent"),
    JVM("jvm"),
    JVMS("jvms"),
    JVM_OPTIONS("jvm-options"),
    KEYSTORE("keystore"),
    LDAP("ldap"),
    LINK_LOCAL_ADDRESS("link-local-address"),
    LOCAL("local"),
    LOOPBACK("loopback"),
    LOOPBACK_ADDRESS("loopback-address"),
    MANAGEMENT("management"),
    MANAGEMENT_INTERFACES("management-interfaces"),
    MULTICAST("multicast"),
    NAME("name"),
    NATIVE_INTERFACE("native-interface"),
    NIC("nic"),
    NIC_MATCH("nic-match"),
    NOT("not"),
    OPTION("option"),
    OUTBOUND_CONNECTIONS("outbound-connections"),
    PASSWORD("password"),
    PATH("path"),
    PATHS("paths"),
    POINT_TO_POINT("point-to-point"),
    PERMGEN("permgen"),
    PROFILE("profile"),
    PROFILES("profiles"),
    PROPERTY("property"),
    PROPERTIES("properties"),
    PUBLIC_ADDRESS("public-address"),
    REMOTE("remote"),
    SCANNING("scanning"),
    SECRET("secret"),
    SECURITY_REALM("security-realm"),
    SECURITY_REALMS("security-realms"),
    SERVER("server"),
    SERVER_IDENTITIES("server-identities"),
    SERVERS("servers"),
    SERVER_GROUP("server-group"),
    SERVER_GROUPS("server-groups"),
    SITE_LOCAL_ADDRESS("site-local-address"),
    SOCKET_BINDING("socket-binding"),
    SOCKET_BINDING_GROUP("socket-binding-group"),
    SOCKET_BINDING_GROUPS("socket-binding-groups"),
    SSL("ssl"),
    STACK("stack"),
    STANDALONE("standalone"),
    SUBNET_MATCH("subnet-match"),
    SUBSYSTEM("subsystem"),
    SYSTEM_PROPERTIES("system-properties"),
    UP("up"),
    USER("user"),
    USERS("users"),
    VARIABLE("variable"),
    VIRTUAL("virtual");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

