/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.protocol.old.StreamUtils;

public class ConfigurationFile {
    private static final String LAST = "last";
    private static final String INITIAL = "initial";
    private static final String BOOT = "boot";
    private static final String LAST_SUFFIX = "last.xml";
    private static final String INITIAL_SUFFIX = "initial.xml";
    private static final String ORIGINAL_SUFFIX = "boot.xml";
    private static final int CURRENT_HISTORY_LENGTH = 100;
    private static final int HISTORY_DAYS = 30;
    private static final String TIMESTAMP_STRING = "\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d";
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d");
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmmssSSS";
    private static final Pattern VERSION_PATTERN = Pattern.compile("v\\d+");
    private static final Pattern FILE_WITH_VERSION_PATTERN = Pattern.compile("\\S*\\.v\\d+\\.xml");
    private static final Pattern SNAPSHOT_XML = Pattern.compile("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d\\S*\\.xml");
    private final AtomicInteger sequence = new AtomicInteger();
    private final AtomicBoolean doneBootup = new AtomicBoolean();
    private final File configurationDir;
    private final String rawFileName;
    private final String bootFileName;
    private volatile File bootFile;
    private final File mainFile;
    private final String mainFileName;
    private final File historyRoot;
    private final File currentHistory;
    private final File snapshotsDirectory;

    public ConfigurationFile(File configurationDir, String rawName, String name) {
        if (!configurationDir.exists() || !configurationDir.isDirectory()) {
            throw new IllegalArgumentException("No directory " + configurationDir.getAbsolutePath() + " was found");
        }
        this.rawFileName = rawName;
        this.bootFileName = name != null ? name : rawName;
        this.configurationDir = configurationDir;
        this.historyRoot = new File(configurationDir, rawName.replace('.', '_') + "_history");
        this.currentHistory = new File(this.historyRoot, "current");
        this.snapshotsDirectory = new File(this.historyRoot, "snapshot");
        File file = this.determineMainFile(configurationDir, rawName, name);
        try {
            this.mainFile = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not get canonical file for main file: " + file, ioe);
        }
        this.mainFileName = this.mainFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getBootFile() {
        if (this.bootFile == null) {
            ConfigurationFile configurationFile = this;
            synchronized (configurationFile) {
                if (this.bootFile == null) {
                    if (this.bootFileName.equals(this.rawFileName)) {
                        this.bootFile = this.mainFile;
                    } else {
                        this.bootFile = this.determineBootFile(this.configurationDir, this.bootFileName);
                        try {
                            this.bootFile = this.bootFile.getCanonicalFile();
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException("Could not get canonical file for boot file: " + this.bootFile, ioe);
                        }
                    }
                }
            }
        }
        return this.bootFile;
    }

    private File determineMainFile(File configurationDir, String rawName, String name) {
        String mainName = null;
        if (name == null) {
            mainName = rawName;
        } else if (name.equals(LAST) || name.equals(INITIAL) || name.equals(BOOT)) {
            mainName = this.findMainFileFromBackupSuffix(this.historyRoot, name);
        } else if (VERSION_PATTERN.matcher(name).matches()) {
            mainName = this.findMainFileFromBackupSuffix(this.currentHistory, name);
        }
        if (mainName == null) {
            mainName = this.findMainFileFromSnapshotPrefix(name);
        }
        if (mainName == null) {
            File directoryFile = new File(configurationDir, name);
            if (directoryFile.exists()) {
                mainName = this.stripPrefixSuffix(name);
            } else {
                File absoluteFile = new File(name);
                if (absoluteFile.exists()) {
                    mainName = this.stripPrefixSuffix(absoluteFile.getName());
                } else {
                    throw new IllegalArgumentException("Neither " + directoryFile.getAbsolutePath() + " nor " + absoluteFile.getAbsolutePath() + " exist");
                }
            }
        }
        return new File(configurationDir, mainName);
    }

    private String findMainFileFromBackupSuffix(File searchDir, String backupType) {
        final String suffix = "." + backupType + ".xml";
        File[] files = null;
        if (searchDir.exists() && searchDir.isDirectory()) {
            files = searchDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            });
        }
        if (files == null || files.length == 0) {
            throw new IllegalStateException(String.format("No configuration file ending in %s found in %s", suffix, searchDir));
        }
        if (files.length > 1) {
            throw new IllegalStateException(String.format("Ambiguous configuration file name '%s' as there are multiple files in %s that end in %s", backupType, searchDir, suffix));
        }
        String matchName = files[0].getName();
        if (matchName.equals(suffix)) {
            throw new IllegalArgumentException(String.format("Configuration files whose complete name is %s are not allowed", backupType));
        }
        String prefix = matchName.substring(0, matchName.length() - suffix.length());
        return prefix + ".xml";
    }

    private String findMainFileFromSnapshotPrefix(final String prefix) {
        File[] files = null;
        if (this.snapshotsDirectory.exists() && this.snapshotsDirectory.isDirectory()) {
            files = this.snapshotsDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
        }
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length > 1) {
            throw new IllegalStateException(String.format("Ambiguous configuration file name '%s' as there are multiple files in %s that start with %s", prefix, this.snapshotsDirectory, prefix));
        }
        String matchName = files[0].getName();
        return matchName.substring(TIMESTAMP_FORMAT.length());
    }

    private String stripPrefixSuffix(String name) {
        if (SNAPSHOT_XML.matcher(name).matches()) {
            name = name.substring(TIMESTAMP_FORMAT.length());
        }
        if (FILE_WITH_VERSION_PATTERN.matcher(name).matches()) {
            int last = name.lastIndexOf(118);
            name = name.substring(0, last) + "xml";
        } else if (name.endsWith(LAST_SUFFIX)) {
            name = name.substring(0, name.length() - LAST_SUFFIX.length()) + "xml";
        } else if (name.endsWith(ORIGINAL_SUFFIX)) {
            name = name.substring(0, name.length() - ORIGINAL_SUFFIX.length()) + "xml";
        } else if (name.endsWith(INITIAL_SUFFIX)) {
            name = name.substring(0, name.length() - INITIAL_SUFFIX.length()) + "xml";
        }
        return name;
    }

    private File determineBootFile(File configurationDir, String name) {
        File versioned;
        if (name.equals(LAST) || name.equals(INITIAL) || name.equals(BOOT)) {
            return this.addSuffixToFile(new File(this.historyRoot, this.mainFile.getName()), name);
        }
        if (VERSION_PATTERN.matcher(name).matches() && (versioned = this.getVersionedFile(this.mainFile, name)).exists()) {
            return versioned;
        }
        File snapshot = this.findSnapshotWithPrefix(name, false);
        if (snapshot != null) {
            return snapshot;
        }
        File directoryFile = new File(configurationDir, name);
        if (directoryFile.exists()) {
            return directoryFile;
        }
        File absoluteFile = new File(name);
        if (absoluteFile.exists()) {
            return absoluteFile;
        }
        throw new IllegalArgumentException("Neither " + directoryFile.getAbsolutePath() + " nor " + absoluteFile.getAbsolutePath() + " exist");
    }

    File getMainFile() {
        return this.mainFile;
    }

    public boolean isMainFile() {
        return this.mainFile.equals(this.getBootFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void successfulBoot() throws ConfigurationPersistenceException {
        ConfigurationFile configurationFile = this;
        synchronized (configurationFile) {
            if (this.doneBootup.get()) {
                return;
            }
            try {
                if (!this.bootFile.equals(this.mainFile)) {
                    this.copyFile(this.bootFile, this.mainFile);
                }
                this.createHistoryDirectory();
                File historyBase = new File(this.historyRoot, this.mainFile.getName());
                File last = this.addSuffixToFile(historyBase, LAST);
                File original = this.addSuffixToFile(historyBase, BOOT);
                File initial = this.addSuffixToFile(historyBase, INITIAL);
                if (!initial.exists()) {
                    this.copyFile(this.mainFile, initial);
                }
                this.copyFile(this.mainFile, last);
                this.copyFile(this.mainFile, original);
                this.snapshot();
            }
            catch (IOException e) {
                throw new ConfigurationPersistenceException(String.format("Failed to create backup copies of configuration file %s", this.bootFile), e);
            }
            this.doneBootup.set(true);
        }
    }

    void backup() throws ConfigurationPersistenceException {
        if (!this.doneBootup.get()) {
            return;
        }
        try {
            File delete;
            this.moveFile(this.mainFile, this.getVersionedFile(this.mainFile));
            int seq = this.sequence.get();
            if (seq > 100 && (delete = this.getVersionedFile(this.mainFile, seq - 100)).exists()) {
                delete.delete();
            }
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException("Failed to back up " + this.mainFile, e);
        }
    }

    void fileWritten() throws ConfigurationPersistenceException {
        if (!this.doneBootup.get()) {
            return;
        }
        File last = this.addSuffixToFile(new File(this.currentHistory, this.mainFile.getName()), LAST);
        try {
            this.copyFile(this.mainFile, last);
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException("Failed to back up " + this.mainFile, e);
        }
    }

    private void moveFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        if (!file.renameTo(backup) && file.exists()) {
            this.copyFile(file, backup);
        }
    }

    String snapshot() throws ConfigurationPersistenceException {
        String name = ConfigurationFile.getTimeStamp(new Date()) + this.mainFileName;
        File snapshot = new File(this.snapshotsDirectory, name);
        try {
            this.copyFile(this.mainFile, snapshot);
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException("Failed to take a snapshot of " + this.mainFile + " to " + snapshot, e);
        }
        return snapshot.toString();
    }

    ConfigurationPersister.SnapshotInfo listSnapshots() {
        return new BackupSnapshotInfo();
    }

    void deleteSnapshot(String prefix) {
        this.findSnapshotWithPrefix(prefix, true).delete();
    }

    private File findSnapshotWithPrefix(String prefix, boolean errorIfNoFiles) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.snapshotsDirectory.exists() && this.snapshotsDirectory.isDirectory()) {
            for (String curr : this.snapshotsDirectory.list()) {
                if (!curr.startsWith(prefix)) continue;
                names.add(curr);
            }
        }
        if (names.size() == 0 && errorIfNoFiles) {
            throw new IllegalArgumentException("No files beginning with '" + prefix + "' found in " + this.snapshotsDirectory.getAbsolutePath());
        }
        if (names.size() > 1) {
            throw new IllegalArgumentException("Ambiguous name '" + prefix + "' in " + this.snapshotsDirectory.getAbsolutePath() + ": " + ((Object)names).toString());
        }
        return names.size() > 0 ? new File(this.snapshotsDirectory, (String)names.get(0)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, File backup) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            FileOutputStream fos = new FileOutputStream(backup);
            try {
                StreamUtils.copyStream((InputStream)fis, (OutputStream)fos);
                fos.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)fos);
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)fis);
        }
    }

    private void createHistoryDirectory() throws IOException {
        this.mkdir(this.historyRoot);
        this.mkdir(this.snapshotsDirectory);
        if (this.currentHistory.exists()) {
            if (!this.currentHistory.isDirectory()) {
                throw new IllegalStateException(this.currentHistory.getAbsolutePath() + " is not a directory");
            }
            Date date = new Date();
            if (this.currentHistory.listFiles().length > 0) {
                String backupName = ConfigurationFile.getTimeStamp(date);
                File old = new File(this.historyRoot, backupName);
                if (!new File(this.currentHistory.getAbsolutePath()).renameTo(old)) {
                    throw new IllegalStateException("Could not rename " + this.currentHistory.getAbsolutePath() + " to " + old.getAbsolutePath());
                }
            }
            String cutoffFileName = ConfigurationFile.getTimeStamp(this.subtractDays(date, 30));
            for (String name : this.historyRoot.list()) {
                if (name.length() != cutoffFileName.length() || !TIMESTAMP_PATTERN.matcher(name).matches() || name.compareTo(cutoffFileName) >= 0) continue;
                this.deleteRecursive(new File(this.historyRoot, name));
            }
        }
        this.currentHistory.mkdir();
        if (!this.currentHistory.exists()) {
            throw new IllegalStateException("Could not create " + this.currentHistory.getAbsolutePath());
        }
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (String name : file.list()) {
                this.deleteRecursive(new File(file, name));
            }
        }
        if (!file.delete()) {
            throw new IllegalStateException("Could not delete " + file);
        }
    }

    private File getVersionedFile(File file) {
        return this.getVersionedFile(file, this.sequence.incrementAndGet());
    }

    private File getVersionedFile(File file, int i) {
        return this.addSuffixToFile(new File(this.currentHistory, file.getName()), "v" + i);
    }

    private File getVersionedFile(File file, String versionString) {
        return this.addSuffixToFile(new File(this.currentHistory, file.getName()), versionString);
    }

    private File addSuffixToFile(File file, String suffix) {
        String path = file.getAbsolutePath();
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return new File(file.getAbsolutePath() + "." + suffix);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(path.substring(0, index));
        sb.append(".");
        sb.append(suffix);
        sb.append(path.substring(index));
        return new File(sb.toString());
    }

    private Date subtractDays(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int doy = calendar.get(6);
        calendar.set(6, doy - days);
        return calendar.getTime();
    }

    private static String getTimeStamp(Date date) {
        SimpleDateFormat sfd = new SimpleDateFormat(TIMESTAMP_FORMAT);
        return sfd.format(date);
    }

    private File mkdir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdir()) {
                throw new IllegalStateException("Could not create " + this.historyRoot.getAbsolutePath());
            }
        } else if (!dir.isDirectory()) {
            throw new IllegalStateException(dir.getAbsolutePath() + " is not a directory");
        }
        return dir;
    }

    private class BackupSnapshotInfo
    implements ConfigurationPersister.SnapshotInfo {
        final ArrayList<String> names = new ArrayList();

        public BackupSnapshotInfo() {
            for (String name : ConfigurationFile.this.snapshotsDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return SNAPSHOT_XML.matcher(name).matches();
                }
            })) {
                this.names.add(name);
            }
        }

        @Override
        public String getSnapshotDirectory() {
            return ConfigurationFile.this.snapshotsDirectory.getAbsolutePath();
        }

        @Override
        public List<String> names() {
            return this.names;
        }
    }
}

