/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.as.weld.injection.WeldEEInjection;
import org.jboss.as.weld.injection.WeldManagedReference;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldManagedReferenceFactory
implements ManagedReferenceFactory,
Service<WeldManagedReferenceFactory> {
    private final Class<?> componentClass;
    private final InjectedValue<WeldContainer> weldContainer;
    private final String ejbName;
    private final Set<Class<?>> interceptorClasses;
    private final Map<Class<?>, WeldEEInjection> interceptorInjections = new HashMap();
    private final ClassLoader classLoader;
    private final String beanDeploymentArchiveId;
    private WeldEEInjection injectionTarget;
    private Bean<?> bean;
    private BeanManagerImpl beanManager;

    public WeldManagedReferenceFactory(Class<?> componentClass, String ejbName, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        this.componentClass = componentClass;
        this.ejbName = ejbName;
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
        this.weldContainer = new InjectedValue();
        this.interceptorClasses = interceptorClasses;
        this.classLoader = classLoader;
    }

    public ManagedReference getReference() {
        WeldCreationalContext ctx = this.bean == null ? this.beanManager.createCreationalContext(null) : this.beanManager.createCreationalContext(this.bean);
        Object instance = this.injectionTarget.produce((CreationalContext<?>)ctx);
        return new WeldManagedReference((CreationalContext<?>)ctx, instance, this.injectionTarget, this.interceptorInjections);
    }

    public ManagedReference injectExistingReference(final ManagedReference existing) {
        WeldCreationalContext ctx = this.bean == null ? this.beanManager.createCreationalContext(null) : this.beanManager.createCreationalContext(this.bean);
        Object instance = existing.getInstance();
        this.injectionTarget.inject(instance, (CreationalContext<?>)ctx);
        return new ManagedReference((CreationalContext)ctx, instance){
            final /* synthetic */ CreationalContext val$ctx;
            final /* synthetic */ Object val$instance;
            {
                this.val$ctx = creationalContext;
                this.val$instance = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release() {
                try {
                    existing.release();
                }
                finally {
                    this.val$ctx.release();
                }
            }

            public Object getInstance() {
                return this.val$instance;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            EjbDescriptor descriptor;
            SecurityActions.setContextClassLoader(this.classLoader);
            this.beanManager = (BeanManagerImpl)((WeldContainer)this.weldContainer.getValue()).getBeanManager(this.beanDeploymentArchiveId);
            for (Class<?> interceptor : this.interceptorClasses) {
                this.interceptorInjections.put(interceptor, WeldEEInjection.createWeldEEInjection(interceptor, null, this.beanManager));
            }
            if (this.ejbName != null && (descriptor = this.beanManager.getEjbDescriptor(this.ejbName)) != null) {
                this.bean = this.beanManager.getBean(descriptor);
            }
            this.injectionTarget = WeldEEInjection.createWeldEEInjection(this.componentClass, this.bean, this.beanManager);
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
    }

    public synchronized void stop(StopContext context) {
        this.injectionTarget = null;
        this.interceptorInjections.clear();
        this.bean = null;
    }

    public WeldManagedReferenceFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldContainer> getWeldContainer() {
        return this.weldContainer;
    }
}

