/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class ModuleGroupSingletonProvider
extends SingletonProvider {
    public static Map<ClassLoader, Set<ClassLoader>> deploymentClassLoaders = new ConcurrentHashMap<ClassLoader, Set<ClassLoader>>();

    public static void addClassLoaders(ClassLoader topLevel, Set<ClassLoader> allClassLoaders) {
        deploymentClassLoaders.put(topLevel, allClassLoaders);
    }

    public static void removeClassLoader(ClassLoader topLevel) {
        deploymentClassLoaders.remove(topLevel);
    }

    public <T> Singleton<T> create(Class<? extends T> type) {
        return new TCCLSingleton();
    }

    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new Hashtable<ClassLoader, T>();

        private TCCLSingleton() {
        }

        public T get() {
            T instance = this.store.get(this.getClassLoader());
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + this.getClassLoader());
            }
            return instance;
        }

        public void set(T object) {
            ClassLoader classLoader = this.getClassLoader();
            this.store.put(classLoader, object);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    this.store.put(cl, object);
                }
            }
        }

        public void clear() {
            ClassLoader classLoader = this.getClassLoader();
            this.store.remove(classLoader);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    this.store.remove(cl);
                }
            }
        }

        public boolean isSet() {
            return this.store.containsKey(this.getClassLoader());
        }

        private ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

