/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.jsfunit.framework.FacesContextBridge;

public class JSFTimer {
    public static final String REQUEST_KEY = JSFTimer.class.getName() + ".REQUEST_KEY";
    private Map<PhaseId, Long> beforeMap = new HashMap<PhaseId, Long>(5);
    private Map<PhaseId, Long> afterMap = new HashMap<PhaseId, Long>(5);

    private JSFTimer() {
    }

    void beforePhase(PhaseId phaseId) {
        this.beforeMap.put(phaseId, new Long(System.currentTimeMillis()));
    }

    void afterPhase(PhaseId phaseId) {
        this.afterMap.put(phaseId, new Long(System.currentTimeMillis()));
    }

    public static JSFTimer getTimer() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            if (facesContext == null) {
                facesContext = FacesContextBridge.getCurrentInstance();
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("No JSF request has been made for this session.");
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        JSFTimer timer = (JSFTimer)requestMap.get(REQUEST_KEY);
        if (timer == null) {
            timer = new JSFTimer();
            requestMap.put(REQUEST_KEY, timer);
        }
        return timer;
    }

    public long getTotalTime() {
        long firstTimeStamp = Long.MAX_VALUE;
        for (long time : this.beforeMap.values()) {
            if (time >= firstTimeStamp) continue;
            firstTimeStamp = time;
        }
        long lastTimeStamp = Long.MIN_VALUE;
        for (long time : this.afterMap.values()) {
            if (time <= lastTimeStamp) continue;
            lastTimeStamp = time;
        }
        if (firstTimeStamp == Long.MAX_VALUE || lastTimeStamp == Long.MIN_VALUE) {
            return -1L;
        }
        return lastTimeStamp - firstTimeStamp;
    }

    public long getPhaseTime(PhaseId phaseId) {
        if (phaseId == PhaseId.ANY_PHASE) {
            throw new IllegalArgumentException("PhaseId.ANY_PHASE is not valid.");
        }
        Long beforeTime = this.beforeMap.get(phaseId);
        Long afterTime = this.afterMap.get(phaseId);
        if (beforeTime == null || afterTime == null) {
            return 0L;
        }
        return afterTime - beforeTime;
    }
}

