/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapProxy<K, V>
extends AutoBatchSupport
implements AtomicMap<K, V> {
    private static final Log log = LogFactory.getLog(AtomicHashMapProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    Object deltaMapKey;
    Cache cache;
    InvocationContextContainer icc;
    volatile boolean startedReadingMap = false;

    AtomicHashMapProxy(Cache<?, ?> cache, Object deltaMapKey, BatchContainer batchContainer, InvocationContextContainer icc) {
        this.cache = cache;
        this.deltaMapKey = deltaMapKey;
        this.batchContainer = batchContainer;
        this.icc = icc;
    }

    private AtomicHashMap<K, V> toMap(Object object) {
        Object map = object instanceof MarshalledValue ? ((MarshalledValue)object).get() : object;
        return (AtomicHashMap)map;
    }

    private AtomicHashMap<K, V> getDeltaMapForRead() {
        AtomicHashMap<K, V> ahm = this.toMap(this.cache.get(this.deltaMapKey));
        if (ahm != null && !this.startedReadingMap) {
            this.startedReadingMap = true;
        }
        this.assertValid(ahm);
        return ahm;
    }

    private AtomicHashMap<K, V> getDeltaMapForWrite(InvocationContext ctx) {
        AtomicHashMap<K, V> map;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = ctx.lookupEntry(this.deltaMapKey);
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toMap((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaMapForRead();
        }
        boolean suppressLocks = ctx.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks) {
            ctx.setFlags(Flag.FORCE_WRITE_LOCK);
        }
        if (trace) {
            if (suppressLocks) {
                log.trace("Skip locking flag used.  Skipping locking.");
            } else {
                log.trace("Forcing write lock even for reads");
            }
        }
        AtomicHashMap<K, V> copy = (map = this.getDeltaMapForRead()) == null ? new AtomicHashMap<K, V>(true) : map.copyForWrite();
        copy.initForWriting();
        if (suppressLocks) {
            ctx.setFlags(Flag.SKIP_LOCKING);
        }
        this.cache.put(this.deltaMapKey, copy);
        return copy;
    }

    private void assertValid(AtomicHashMap<?, ?> map) {
        if (this.startedReadingMap && (map == null || map.removed)) {
            throw new IllegalStateException("AtomicMap stored under key " + this.deltaMapKey + " has been concurrently removed!");
        }
    }

    @Override
    public Set<K> keySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    public Collection<V> values() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Override
    public int size() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean isEmpty() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null || map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map != null && map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map != null && map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? null : (V)map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        try {
            this.startAtomic();
            InvocationContext ctx = this.icc.createInvocationContext();
            AtomicHashMap<K, V> deltaMapForWrite = this.getDeltaMapForWrite(ctx);
            V v = deltaMapForWrite.put(key, value);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            V v = this.getDeltaMapForWrite(ic).remove(key);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            this.getDeltaMapForWrite(ic).putAll(m);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            this.getDeltaMapForWrite(ic).clear();
        }
        finally {
            this.endAtomic();
        }
    }

    public String toString() {
        return "AtomicHashMapProxy{deltaMapKey=" + this.deltaMapKey + '}';
    }
}

