/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PrepareCommand
extends AbstractTransactionBoundaryCommand {
    private static final Log log = LogFactory.getLog(PrepareCommand.class);
    private boolean trace = log.isTraceEnabled();
    public static final byte COMMAND_ID = 12;
    protected WriteCommand[] modifications;
    protected boolean onePhaseCommit;
    protected CacheNotifier notifier;
    protected RecoveryManager recoveryManager;

    public void initialize(CacheNotifier notifier, RecoveryManager recoveryManager) {
        this.notifier = notifier;
        this.recoveryManager = recoveryManager;
    }

    public PrepareCommand(GlobalTransaction gtx, boolean onePhaseCommit, WriteCommand ... modifications) {
        this.globalTx = gtx;
        this.modifications = modifications;
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(GlobalTransaction gtx, List<WriteCommand> commands, boolean onePhaseCommit) {
        this.globalTx = gtx;
        this.modifications = commands == null || commands.isEmpty() ? null : commands.toArray(new WriteCommand[commands.size()]);
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand() {
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        boolean remoteTxInitiated;
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        if (this.recoveryManager != null && this.recoveryManager.isTransactionPrepared(this.globalTx)) {
            log.tracef("The transaction %s is already prepared. Skipping prepare call.", this.globalTx);
            return null;
        }
        RemoteTransaction remoteTransaction = this.txTable.getRemoteTransaction(this.globalTx);
        boolean bl = remoteTxInitiated = remoteTransaction != null;
        if (!remoteTxInitiated) {
            remoteTransaction = this.txTable.createRemoteTransaction(this.globalTx, this.modifications);
        } else {
            remoteTransaction.setModifications(this.getModifications());
        }
        RemoteTxInvocationContext ctx = this.icc.createRemoteTxInvocationContext(this.getOrigin());
        ctx.setRemoteTransaction(remoteTransaction);
        if (this.trace) {
            log.tracef("Invoking remotely originated prepare: %s with invocation context: %s", this, ctx);
        }
        this.notifier.notifyTransactionRegistered(ctx.getGlobalTransaction(), ctx);
        return this.invoker.invoke(ctx, this);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand((TxInvocationContext)ctx, this);
    }

    public WriteCommand[] getModifications() {
        return this.modifications == null ? new WriteCommand[]{} : this.modifications;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    public boolean existModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public int getModificationsCount() {
        return this.modifications != null ? this.modifications.length : 0;
    }

    @Override
    public byte getCommandId() {
        return 12;
    }

    @Override
    public Object[] getParameters() {
        int numMods = this.modifications == null ? 0 : this.modifications.length;
        Object[] retval = new Object[numMods + 4];
        retval[0] = this.globalTx;
        retval[1] = this.cacheName;
        retval[2] = this.onePhaseCommit;
        retval[3] = numMods;
        if (numMods > 0) {
            System.arraycopy(this.modifications, 0, retval, 4, numMods);
        }
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.globalTx = (GlobalTransaction)args[0];
        this.cacheName = (String)args[1];
        this.onePhaseCommit = (Boolean)args[2];
        int numMods = (Integer)args[3];
        if (numMods > 0) {
            this.modifications = new WriteCommand[numMods];
            System.arraycopy(args, 4, this.modifications, 0, numMods);
        }
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand();
        copy.globalTx = this.globalTx;
        copy.modifications = this.modifications == null ? null : (WriteCommand[])this.modifications.clone();
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    @Override
    public String toString() {
        return "PrepareCommand {gtx=" + this.globalTx + ", modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", " + super.toString();
    }

    public boolean containsModificationType(Class<? extends ReplicableCommand> replicableCommandClass) {
        for (WriteCommand mod : this.getModifications()) {
            if (!mod.getClass().equals(replicableCommandClass)) continue;
            return true;
        }
        return false;
    }

    public boolean hasModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public Set<Object> getAffectedKeys() {
        if (this.modifications == null || this.modifications.length == 0) {
            return Collections.emptySet();
        }
        if (this.modifications.length == 1) {
            return this.modifications[0].getAffectedKeys();
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (WriteCommand wc : this.modifications) {
            keys.addAll(wc.getAffectedKeys());
        }
        return keys;
    }
}

