/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Set;
import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;

public class ConfigurationValidatingVisitor
extends AbstractConfigurationBeanVisitor {
    private GlobalConfiguration.TransportType tt = null;

    @Override
    public void visitSingletonStoreConfig(SingletonStoreConfig ssc) {
        if (this.tt == null && ssc.isSingletonStoreEnabled().booleanValue()) {
            throw new ConfigurationException("Singleton store configured without transport being configured");
        }
    }

    @Override
    public void visitTransportType(GlobalConfiguration.TransportType tt) {
        this.tt = tt;
    }

    @Override
    public void visitConfiguration(Configuration bean) {
    }

    @Override
    public void visitClusteringType(Configuration.ClusteringType clusteringType) {
        Configuration.CacheMode mode = clusteringType.mode;
        Configuration.AsyncType async = clusteringType.async;
        Configuration.StateRetrievalType state = clusteringType.stateRetrieval;
        if (mode.isDistributed() && state.fetchInMemoryState.booleanValue()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true.  Perhaps you meant to enable rehashing?");
        }
        if (mode.isDistributed() && async.useReplQueue.booleanValue()) {
            throw new ConfigurationException("Use of the replication queue is invalid when using DISTRIBUTED mode.");
        }
        if (mode.isSynchronous() && async.useReplQueue.booleanValue()) {
            throw new ConfigurationException("Use of the replication queue is only allowed with an ASYNCHRONOUS cluster mode.");
        }
        Set overriden = clusteringType.stateRetrieval.overriddenConfigurationElements;
        if (mode.isReplicated() && !state.isFetchInMemoryState().booleanValue() && !overriden.contains("fetchInMemoryState")) {
            this.log.debug("Cache is replicated but state transfer was not defined, so force enabling it");
            state.fetchInMemoryState(true);
        }
    }

    @Override
    public void visitL1Type(Configuration.L1Type l1Type) {
        boolean l1Enabled = l1Type.enabled;
        boolean l1OnRehash = l1Type.onRehash;
        if (!l1Enabled && l1OnRehash) {
            Set overridden = l1Type.overriddenConfigurationElements;
            if (overridden.contains("onRehash")) {
                throw new ConfigurationException("Can only move entries to L1 on rehash when L1 is enabled");
            }
            this.log.debug("L1 is disabled and L1OnRehash was not defined, disabling it");
            l1Type.onRehash(false);
        }
    }

    @Override
    public void visitCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        boolean shared = cacheLoaderManagerConfig.isShared();
        if (!shared) {
            for (CacheLoaderConfig loaderConfig : cacheLoaderManagerConfig.getCacheLoaderConfigs()) {
                if (!(loaderConfig instanceof CacheStoreConfig)) continue;
                CacheStoreConfig storeConfig = (CacheStoreConfig)loaderConfig;
                Boolean fetchPersistentState = storeConfig.isFetchPersistentState();
                Boolean purgeOnStartup = storeConfig.isPurgeOnStartup();
                if (fetchPersistentState.booleanValue() || purgeOnStartup.booleanValue()) continue;
                this.log.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
            }
        }
    }

    @Override
    public void visitEvictionType(Configuration.EvictionType et) {
        if (et.strategy.isEnabled() && et.maxEntries <= 0) {
            throw new ConfigurationException("Eviction maxEntries value cannot be less than or equal to zero if eviction is enabled");
        }
    }
}

