/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractConfigurationBeanWithGCR;
import org.infinispan.config.AdvancedExternalizerConfig;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.ConfigurationDocs;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.FluentGlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.executors.DefaultExecutorFactory;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;

@SurvivesRestarts
@Scope(value=Scopes.GLOBAL)
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
@XmlRootElement
@ConfigurationDoc(name="global", desc="Defines global settings shared among all cache instances created by a single CacheManager.")
public class GlobalConfiguration
extends AbstractConfigurationBean {
    private static final long serialVersionUID = 8910865501990177720L;
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    @XmlTransient
    FluentGlobalConfiguration fluentGlobalConfig = new FluentGlobalConfiguration(this);
    @XmlElement
    ExecutorFactoryType asyncListenerExecutor = new ExecutorFactoryType().setGlobalConfiguration(this);
    @XmlElement
    ExecutorFactoryType asyncTransportExecutor = new ExecutorFactoryType().setGlobalConfiguration(this);
    @XmlElement
    ScheduledExecutorFactoryType evictionScheduledExecutor = new ScheduledExecutorFactoryType().setGlobalConfiguration(this);
    @XmlElement
    ScheduledExecutorFactoryType replicationQueueScheduledExecutor = new ScheduledExecutorFactoryType().setGlobalConfiguration(this);
    @XmlElement
    GlobalJmxStatisticsType globalJmxStatistics = new GlobalJmxStatisticsType().setGlobalConfiguration(this);
    @XmlElement
    TransportType transport = new TransportType(null).setGlobalConfiguration(this);
    @XmlElement
    SerializationType serialization = new SerializationType().setGlobalConfiguration(this);
    @XmlElement
    ShutdownType shutdown = new ShutdownType().setGlobalConfiguration(this);
    @XmlTransient
    GlobalComponentRegistry gcr;
    @XmlTransient
    private final ClassLoader cl;

    public GlobalConfiguration() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GlobalConfiguration(ClassLoader cl) {
        if (cl == null) {
            throw new IllegalArgumentException("cl must not be null");
        }
        this.cl = cl;
    }

    public FluentGlobalConfiguration fluent() {
        return this.fluentGlobalConfig;
    }

    public boolean isExposeGlobalJmxStatistics() {
        return this.globalJmxStatistics.enabled;
    }

    @Deprecated
    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.testImmutability("exposeGlobalManagementStatistics");
        this.globalJmxStatistics.setEnabled(exposeGlobalJmxStatistics);
    }

    @Deprecated
    public void setJmxDomain(String jmxObjectName) {
        this.globalJmxStatistics.setJmxDomain(jmxObjectName);
    }

    public String getJmxDomain() {
        return this.globalJmxStatistics.jmxDomain;
    }

    public String getMBeanServerLookup() {
        return this.globalJmxStatistics.mBeanServerLookup;
    }

    public Properties getMBeanServerProperties() {
        return this.globalJmxStatistics.properties;
    }

    @Deprecated
    public void setMBeanServerProperties(Properties properties) {
        this.globalJmxStatistics.setProperties(this.toTypedProperties(properties));
    }

    @Deprecated
    public void setMBeanServerLookup(String mBeanServerLookupClass) {
        this.globalJmxStatistics.setMBeanServerLookup(mBeanServerLookupClass);
    }

    @XmlTransient
    @Deprecated
    public void setMBeanServerLookup(MBeanServerLookup mBeanServerLookup) {
        this.globalJmxStatistics.setMBeanServerLookupInstance(mBeanServerLookup);
    }

    @XmlTransient
    @Deprecated
    public void setMBeanServerLookupInstance(MBeanServerLookup mBeanServerLookupInstance) {
        this.globalJmxStatistics.setMBeanServerLookupInstance(mBeanServerLookupInstance);
    }

    public MBeanServerLookup getMBeanServerLookupInstance() {
        return this.globalJmxStatistics.getMBeanServerLookupInstance();
    }

    public boolean isAllowDuplicateDomains() {
        return this.globalJmxStatistics.allowDuplicateDomains;
    }

    @Deprecated
    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.globalJmxStatistics.setAllowDuplicateDomains(allowDuplicateDomains);
    }

    public String getCacheManagerName() {
        return this.globalJmxStatistics.cacheManagerName;
    }

    @Deprecated
    public void setCacheManagerName(String cacheManagerName) {
        this.globalJmxStatistics.setCacheManagerName(cacheManagerName);
    }

    public boolean isStrictPeerToPeer() {
        return this.transport.strictPeerToPeer;
    }

    @Deprecated
    public void setStrictPeerToPeer(boolean strictPeerToPeer) {
        this.transport.setStrictPeerToPeer(strictPeerToPeer);
    }

    public boolean hasTopologyInfo() {
        return this.getSiteId() != null || this.getRackId() != null || this.getMachineId() != null;
    }

    @Inject
    private void injectDependencies(GlobalComponentRegistry gcr) {
        this.gcr = gcr;
        gcr.registerComponent((Object)this.asyncListenerExecutor, "asyncListenerExecutor");
        gcr.registerComponent((Object)this.asyncTransportExecutor, "asyncTransportExecutor");
        gcr.registerComponent((Object)this.evictionScheduledExecutor, "evictionScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.globalJmxStatistics, "globalJmxStatistics");
        gcr.registerComponent((Object)this.transport, "transport");
        gcr.registerComponent((Object)this.serialization, "serialization");
        gcr.registerComponent((Object)this.shutdown, "shutdown");
    }

    @Override
    protected boolean hasComponentStarted() {
        return this.gcr != null && this.gcr.getStatus() != null && this.gcr.getStatus() == ComponentStatus.RUNNING;
    }

    public String getAsyncListenerExecutorFactoryClass() {
        return this.asyncListenerExecutor.factory;
    }

    @Deprecated
    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.asyncListenerExecutor.setFactory(asyncListenerExecutorFactoryClass);
    }

    public String getAsyncTransportExecutorFactoryClass() {
        return this.asyncTransportExecutor.factory;
    }

    @Deprecated
    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.asyncTransportExecutor.setFactory(asyncTransportExecutorFactoryClass);
    }

    public String getEvictionScheduledExecutorFactoryClass() {
        return this.evictionScheduledExecutor.factory;
    }

    @Deprecated
    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.evictionScheduledExecutor.setFactory(evictionScheduledExecutorFactoryClass);
    }

    public String getReplicationQueueScheduledExecutorFactoryClass() {
        return this.replicationQueueScheduledExecutor.factory;
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.replicationQueueScheduledExecutor.setFactory(replicationQueueScheduledExecutorFactoryClass);
    }

    public String getMarshallerClass() {
        return this.serialization.marshallerClass;
    }

    @Deprecated
    public void setMarshallerClass(String marshallerClass) {
        this.serialization.setMarshallerClass(marshallerClass);
    }

    public String getTransportNodeName() {
        return this.transport.nodeName;
    }

    @Deprecated
    public void setTransportNodeName(String nodeName) {
        this.transport.setNodeName(nodeName);
    }

    public String getTransportClass() {
        return this.transport.transportClass;
    }

    @Deprecated
    public void setTransportClass(String transportClass) {
        this.transport.setTransportClass(transportClass);
    }

    public Properties getTransportProperties() {
        return this.transport.properties;
    }

    @Deprecated
    public void setTransportProperties(Properties transportProperties) {
        this.transport.setProperties(this.toTypedProperties(transportProperties));
    }

    @Deprecated
    public void setTransportProperties(String transportPropertiesString) {
        this.transport.setProperties(this.toTypedProperties(transportPropertiesString));
    }

    public String getClusterName() {
        return this.transport.clusterName;
    }

    @Deprecated
    public void setClusterName(String clusterName) {
        this.transport.setClusterName(clusterName);
    }

    @Deprecated
    public void setMachineId(String machineId) {
        this.transport.setMachineId(machineId);
    }

    public String getMachineId() {
        return this.transport.machineId;
    }

    @Deprecated
    public void setRackId(String rackId) {
        this.transport.setRackId(rackId);
    }

    public String getRackId() {
        return this.transport.rackId;
    }

    @Deprecated
    public void setSiteId(String siteId) {
        this.transport.setSiteId(siteId);
    }

    public String getSiteId() {
        return this.transport.siteId;
    }

    public ShutdownHookBehavior getShutdownHookBehavior() {
        return this.shutdown.hookBehavior;
    }

    @Deprecated
    public void setShutdownHookBehavior(ShutdownHookBehavior shutdownHookBehavior) {
        this.shutdown.setHookBehavior(shutdownHookBehavior);
    }

    @Deprecated
    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        if (shutdownHookBehavior == null) {
            throw new ConfigurationException("Shutdown hook behavior cannot be null", "ShutdownHookBehavior");
        }
        ShutdownHookBehavior temp = ShutdownHookBehavior.valueOf(this.uc(shutdownHookBehavior));
        if (temp == null) {
            this.log.warn("Unknown shutdown hook behavior '" + shutdownHookBehavior + "', using defaults.");
            temp = ShutdownHookBehavior.DEFAULT;
        }
        this.setShutdownHookBehavior(temp);
    }

    public Properties getAsyncListenerExecutorProperties() {
        return this.asyncListenerExecutor.properties;
    }

    @Deprecated
    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorProperties));
    }

    @Deprecated
    public void setAsyncListenerExecutorProperties(String asyncListenerExecutorPropertiesString) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorPropertiesString));
    }

    public Properties getAsyncTransportExecutorProperties() {
        return this.asyncTransportExecutor.properties;
    }

    @Deprecated
    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncTransportExecutorProperties));
    }

    @Deprecated
    public void setAsyncTransportExecutorProperties(String asyncSerializationExecutorPropertiesString) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncSerializationExecutorPropertiesString));
    }

    public Properties getEvictionScheduledExecutorProperties() {
        return this.evictionScheduledExecutor.properties;
    }

    @Deprecated
    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorProperties));
    }

    @Deprecated
    public void setEvictionScheduledExecutorProperties(String evictionScheduledExecutorPropertiesString) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorPropertiesString));
    }

    public Properties getReplicationQueueScheduledExecutorProperties() {
        return this.replicationQueueScheduledExecutor.properties;
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorProperties));
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorProperties(String replicationQueueScheduledExecutorPropertiesString) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorPropertiesString));
    }

    public short getMarshallVersion() {
        return Version.getVersionShort(this.serialization.version);
    }

    public String getMarshallVersionString() {
        return this.serialization.version;
    }

    @Deprecated
    public void setMarshallVersion(short marshallVersion) {
        this.testImmutability("marshallVersion");
        this.serialization.version = Version.decodeVersionForSerialization(marshallVersion);
    }

    @Deprecated
    public void setMarshallVersion(String marshallVersion) {
        this.serialization.setVersion(marshallVersion);
    }

    public List<AdvancedExternalizerConfig> getExternalizers() {
        return this.serialization.externalizerTypes.advancedExternalizers;
    }

    public long getDistributedSyncTimeout() {
        return this.transport.distributedSyncTimeout;
    }

    @Deprecated
    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.transport.distributedSyncTimeout = distributedSyncTimeout;
    }

    public void accept(ConfigurationBeanVisitor v) {
        this.asyncListenerExecutor.accept(v);
        this.asyncTransportExecutor.accept(v);
        this.evictionScheduledExecutor.accept(v);
        this.globalJmxStatistics.accept(v);
        this.replicationQueueScheduledExecutor.accept(v);
        this.serialization.accept(v);
        this.shutdown.accept(v);
        this.transport.accept(v);
        v.visitGlobalConfiguration(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfiguration that = (GlobalConfiguration)o;
        if (!this.serialization.version.equals(that.serialization.version)) {
            return false;
        }
        if (this.asyncListenerExecutor.factory != null ? !this.asyncListenerExecutor.factory.equals(that.asyncListenerExecutor.factory) : that.asyncListenerExecutor.factory != null) {
            return false;
        }
        if (this.asyncListenerExecutor.properties != null ? !this.asyncListenerExecutor.properties.equals(that.asyncListenerExecutor.properties) : that.asyncListenerExecutor.properties != null) {
            return false;
        }
        if (this.asyncTransportExecutor.factory != null ? !this.asyncTransportExecutor.factory.equals(that.asyncTransportExecutor.factory) : that.asyncTransportExecutor.factory != null) {
            return false;
        }
        if (this.asyncTransportExecutor.properties != null ? !this.asyncTransportExecutor.properties.equals(that.asyncTransportExecutor.properties) : that.asyncTransportExecutor.properties != null) {
            return false;
        }
        if (this.transport.clusterName != null ? !this.transport.clusterName.equals(that.transport.clusterName) : that.transport.clusterName != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.factory != null ? !this.evictionScheduledExecutor.factory.equals(that.evictionScheduledExecutor.factory) : that.evictionScheduledExecutor.factory != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.properties != null ? !this.evictionScheduledExecutor.properties.equals(that.evictionScheduledExecutor.properties) : that.evictionScheduledExecutor.properties != null) {
            return false;
        }
        if (this.serialization.marshallerClass != null ? !this.serialization.marshallerClass.equals(that.serialization.marshallerClass) : that.serialization.marshallerClass != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.factory != null ? !this.replicationQueueScheduledExecutor.factory.equals(that.replicationQueueScheduledExecutor.factory) : that.replicationQueueScheduledExecutor.factory != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.properties != null ? !this.replicationQueueScheduledExecutor.properties.equals(that.replicationQueueScheduledExecutor.properties) : that.replicationQueueScheduledExecutor.properties != null) {
            return false;
        }
        if (this.shutdown.hookBehavior != null ? !this.shutdown.hookBehavior.equals((Object)that.shutdown.hookBehavior) : that.shutdown.hookBehavior != null) {
            return false;
        }
        if (this.transport.transportClass != null ? !this.transport.transportClass.equals(that.transport.transportClass) : that.transport.transportClass != null) {
            return false;
        }
        if (this.transport.properties != null ? !this.transport.properties.equals(that.transport.properties) : that.transport.properties != null) {
            return false;
        }
        return this.transport.distributedSyncTimeout == null || this.transport.distributedSyncTimeout.equals(that.transport.distributedSyncTimeout);
    }

    public int hashCode() {
        int result = this.asyncListenerExecutor.factory != null ? this.asyncListenerExecutor.factory.hashCode() : 0;
        result = 31 * result + (this.asyncListenerExecutor.properties != null ? this.asyncListenerExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.factory != null ? this.asyncTransportExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.properties != null ? this.asyncTransportExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.factory != null ? this.evictionScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.properties != null ? this.evictionScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.factory != null ? this.replicationQueueScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.properties != null ? this.replicationQueueScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.serialization.marshallerClass != null ? this.serialization.marshallerClass.hashCode() : 0);
        result = 31 * result + (this.transport.transportClass != null ? this.transport.transportClass.hashCode() : 0);
        result = 31 * result + (this.transport.properties != null ? this.transport.properties.hashCode() : 0);
        result = 31 * result + (this.transport.clusterName != null ? this.transport.clusterName.hashCode() : 0);
        result = 31 * result + this.shutdown.hookBehavior.hashCode();
        result = 31 * result + this.serialization.version.hashCode();
        result = (int)((long)(31 * result) + this.transport.distributedSyncTimeout);
        return result;
    }

    @Override
    public GlobalConfiguration clone() {
        try {
            GlobalConfiguration dolly = (GlobalConfiguration)super.clone();
            if (this.asyncListenerExecutor != null) {
                dolly.asyncListenerExecutor = this.asyncListenerExecutor.clone();
                dolly.asyncListenerExecutor.setGlobalConfiguration(dolly);
            }
            if (this.asyncTransportExecutor != null) {
                dolly.asyncTransportExecutor = this.asyncTransportExecutor.clone();
                dolly.asyncTransportExecutor.setGlobalConfiguration(dolly);
            }
            if (this.evictionScheduledExecutor != null) {
                dolly.evictionScheduledExecutor = this.evictionScheduledExecutor.clone();
                dolly.evictionScheduledExecutor.setGlobalConfiguration(dolly);
            }
            if (this.replicationQueueScheduledExecutor != null) {
                dolly.replicationQueueScheduledExecutor = this.replicationQueueScheduledExecutor.clone();
                dolly.evictionScheduledExecutor.setGlobalConfiguration(dolly);
            }
            if (this.globalJmxStatistics != null) {
                dolly.globalJmxStatistics = (GlobalJmxStatisticsType)this.globalJmxStatistics.clone();
                dolly.globalJmxStatistics.setGlobalConfiguration(dolly);
            }
            if (this.transport != null) {
                dolly.transport = this.transport.clone();
                dolly.transport.setGlobalConfiguration(dolly);
            }
            if (this.serialization != null) {
                dolly.serialization = (SerializationType)this.serialization.clone();
                dolly.serialization.setGlobalConfiguration(dolly);
            }
            if (this.shutdown != null) {
                dolly.shutdown = (ShutdownType)this.shutdown.clone();
                dolly.shutdown.setGlobalConfiguration(dolly);
            }
            dolly.fluentGlobalConfig = new FluentGlobalConfiguration(dolly);
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Problems cloning configuration component!", e);
        }
    }

    public String toXmlString() {
        return InfinispanConfiguration.toXmlString(this);
    }

    public static GlobalConfiguration getClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(JGroupsTransport.class.getName());
        gc.setTransportProperties((Properties)null);
        Properties p = new Properties();
        p.setProperty("threadNamePrefix", "asyncTransportThread");
        gc.setAsyncTransportExecutorProperties(p);
        return gc;
    }

    public static GlobalConfiguration getNonClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(null);
        gc.setTransportProperties((Properties)null);
        return gc;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="shutdown")
    public static class ShutdownType
    extends AbstractConfigurationBeanWithGCR
    implements FluentGlobalConfiguration.ShutdownConfig {
        private static final long serialVersionUID = 3427920991221031456L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setShutdownHookBehavior")
        protected ShutdownHookBehavior hookBehavior = ShutdownHookBehavior.DEFAULT;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitShutdownType(this);
        }

        @XmlAttribute
        public ShutdownHookBehavior getHookBehavior() {
            return this.hookBehavior;
        }

        @Deprecated
        public void setHookBehavior(ShutdownHookBehavior hookBehavior) {
            this.testImmutability("hookBehavior");
            this.hookBehavior = hookBehavior;
        }

        @Override
        public FluentGlobalConfiguration.ShutdownConfig hookBehavior(ShutdownHookBehavior hookBehavior) {
            this.setHookBehavior(hookBehavior);
            return this;
        }

        @Override
        ShutdownType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            super.setGlobalConfiguration(globalConfig);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="globalJmxStatistics")
    public static class GlobalJmxStatisticsType
    extends AbstractConfigurationBeanWithGCR
    implements FluentGlobalConfiguration.GlobalJmxStatisticsConfig {
        private static final long serialVersionUID = 6639689526822921024L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setExposeGlobalJmxStatistics")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setJmxDomain")
        protected String jmxDomain = "org.infinispan";
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMBeanServerLookup")
        protected String mBeanServerLookup = PlatformMBeanServerLookup.class.getName();
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setAllowDuplicateDomains")
        protected Boolean allowDuplicateDomains = false;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setCacheManagerName")
        protected String cacheManagerName = "DefaultCacheManager";
        @XmlElement(name="properties")
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMBeanServerProperties")
        protected TypedProperties properties = new TypedProperties();
        private MBeanServerLookup mBeanServerLookupInstance;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitGlobalJmxStatisticsType(this);
        }

        @XmlAttribute
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Deprecated
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @Deprecated
        @XmlTransient
        public void setProperties(TypedProperties p) {
            this.properties = p;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig withProperties(Properties p) {
            this.setProperties(this.toTypedProperties(p));
            return this;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig addProperty(String key, String value) {
            this.properties.setProperty(key, value);
            return this;
        }

        @XmlAttribute
        public String getJmxDomain() {
            return this.jmxDomain;
        }

        @Deprecated
        public void setJmxDomain(String jmxDomain) {
            this.testImmutability("jmxDomain");
            this.jmxDomain = jmxDomain;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig jmxDomain(String jmxDomain) {
            this.setJmxDomain(jmxDomain);
            return this;
        }

        @XmlAttribute
        public String getMBeanServerLookup() {
            return this.mBeanServerLookup;
        }

        @Deprecated
        public void setMBeanServerLookup(String beanServerLookup) {
            this.testImmutability("mBeanServerLookup");
            this.mBeanServerLookup = beanServerLookup;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig mBeanServerLookupClass(Class<? extends MBeanServerLookup> beanServerLookupClass) {
            this.setMBeanServerLookup(beanServerLookupClass == null ? null : beanServerLookupClass.getName());
            return this;
        }

        @XmlAttribute
        public Boolean getAllowDuplicateDomains() {
            return this.allowDuplicateDomains;
        }

        @Deprecated
        public void setAllowDuplicateDomains(Boolean allowDuplicateDomains) {
            this.testImmutability("allowDuplicateDomains");
            this.allowDuplicateDomains = allowDuplicateDomains;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig allowDuplicateDomains(Boolean allowDuplicateDomains) {
            this.setAllowDuplicateDomains(allowDuplicateDomains);
            return this;
        }

        @XmlAttribute
        public String getCacheManagerName() {
            return this.cacheManagerName;
        }

        @Deprecated
        public void setCacheManagerName(String cacheManagerName) {
            this.testImmutability("cacheManagerName");
            this.cacheManagerName = cacheManagerName;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig cacheManagerName(String cacheManagerName) {
            this.setCacheManagerName(cacheManagerName);
            return this;
        }

        @XmlTransient
        public MBeanServerLookup getMBeanServerLookupInstance() {
            if (this.mBeanServerLookupInstance == null) {
                this.mBeanServerLookupInstance = (MBeanServerLookup)Util.getInstance(this.mBeanServerLookup, this.globalConfig.getClassLoader());
            }
            return this.mBeanServerLookupInstance;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig disable() {
            this.setEnabled(false);
            return this;
        }

        @Deprecated
        public void setMBeanServerLookupInstance(MBeanServerLookup MBeanServerLookupInstance) {
            this.mBeanServerLookupInstance = MBeanServerLookupInstance;
        }

        @Override
        public FluentGlobalConfiguration.GlobalJmxStatisticsConfig mBeanServerLookup(MBeanServerLookup MBeanServerLookupInstance) {
            this.mBeanServerLookupInstance = MBeanServerLookupInstance;
            return this;
        }

        @Override
        GlobalJmxStatisticsType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            super.setGlobalConfiguration(globalConfig);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ConfigurationDoc(name="advancedExternalizers")
    public static class AdvancedExternalizersType
    extends AbstractConfigurationBeanWithGCR {
        private static final long serialVersionUID = -496116709223466807L;
        @XmlElement(name="advancedExternalizer")
        private List<AdvancedExternalizerConfig> advancedExternalizers = new ArrayList<AdvancedExternalizerConfig>();

        @Override
        public AdvancedExternalizersType clone() throws CloneNotSupportedException {
            AdvancedExternalizersType dolly = (AdvancedExternalizersType)super.clone();
            if (this.advancedExternalizers != null) {
                dolly.advancedExternalizers = new ArrayList<AdvancedExternalizerConfig>();
                for (AdvancedExternalizerConfig config : this.advancedExternalizers) {
                    AdvancedExternalizerConfig clone = (AdvancedExternalizerConfig)config.clone();
                    dolly.advancedExternalizers.add(clone);
                }
            }
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            for (AdvancedExternalizerConfig i : this.advancedExternalizers) {
                i.accept(v);
            }
            v.visitAdvancedExternalizersType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AdvancedExternalizersType)) {
                return false;
            }
            AdvancedExternalizersType that = (AdvancedExternalizersType)o;
            return !(this.advancedExternalizers != null ? !((Object)this.advancedExternalizers).equals(that.advancedExternalizers) : that.advancedExternalizers != null);
        }

        public int hashCode() {
            return this.advancedExternalizers != null ? ((Object)this.advancedExternalizers).hashCode() : 0;
        }

        AdvancedExternalizersType addExternalizer(AdvancedExternalizerConfig e) {
            this.advancedExternalizers.add(e);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="serialization")
    public static class SerializationType
    extends AbstractConfigurationBeanWithGCR
    implements FluentGlobalConfiguration.SerializationConfig {
        private static final long serialVersionUID = -925947118621507282L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMarshallerClass")
        protected String marshallerClass = VersionAwareMarshaller.class.getName();
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMarshallVersion")
        protected String version = "5.0";
        private short versionShort;
        @XmlElement(name="advancedExternalizers")
        protected AdvancedExternalizersType externalizerTypes = new AdvancedExternalizersType();

        public void accept(ConfigurationBeanVisitor v) {
            v.visitSerializationType(this);
        }

        @XmlAttribute
        public String getMarshallerClass() {
            return this.marshallerClass;
        }

        @Deprecated
        public void setMarshallerClass(String marshallerClass) {
            this.testImmutability("marshallerClass");
            this.marshallerClass = marshallerClass;
        }

        @Override
        public FluentGlobalConfiguration.SerializationConfig marshallerClass(Class<? extends Marshaller> marshallerClass) {
            this.setMarshallerClass(marshallerClass == null ? null : marshallerClass.getName());
            return this;
        }

        @XmlAttribute
        public String getVersion() {
            return this.version;
        }

        @Deprecated
        public void setVersion(String version) {
            this.testImmutability("version");
            this.version = version;
        }

        @Override
        public FluentGlobalConfiguration.SerializationConfig version(String version) {
            this.setVersion(version);
            return this;
        }

        @Override
        public FluentGlobalConfiguration.SerializationConfig version(short marshallVersion) {
            this.versionShort = marshallVersion;
            return this;
        }

        @Override
        SerializationType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            this.externalizerTypes.setGlobalConfiguration(globalConfig);
            super.setGlobalConfiguration(globalConfig);
            return this;
        }

        @Override
        public <T> FluentGlobalConfiguration.SerializationConfig addAdvancedExternalizer(Class<? extends AdvancedExternalizer<T>> clazz) {
            this.addAdvancedExternalizer(Integer.MAX_VALUE, clazz);
            return this;
        }

        @Override
        public <T> FluentGlobalConfiguration.SerializationConfig addAdvancedExternalizer(int id, Class<? extends AdvancedExternalizer<T>> clazz) {
            AdvancedExternalizerConfig ec = new AdvancedExternalizerConfig();
            ec.setExternalizerClass(clazz.getName());
            if (id != Integer.MAX_VALUE) {
                ec.setId(id);
            }
            this.externalizerTypes.addExternalizer(ec);
            return this;
        }

        @Override
        public <T> FluentGlobalConfiguration.SerializationConfig addAdvancedExternalizer(AdvancedExternalizer<T> ... advancedExternalizers) {
            for (AdvancedExternalizer<T> ext : advancedExternalizers) {
                this.externalizerTypes.addExternalizer(new AdvancedExternalizerConfig().setAdvancedExternalizer(ext));
            }
            return this;
        }

        @Override
        public <T> FluentGlobalConfiguration.SerializationConfig addAdvancedExternalizer(int id, AdvancedExternalizer<T> advancedExternalizer) {
            this.externalizerTypes.addExternalizer(new AdvancedExternalizerConfig().setId(id).setAdvancedExternalizer(advancedExternalizer));
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="transport")
    public static class TransportType
    extends AbstractConfigurationBeanWithGCR
    implements FluentGlobalConfiguration.TransportConfig {
        private static final long serialVersionUID = -4739815717370060368L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setClusterName")
        protected String clusterName = "Infinispan-Cluster";
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMachineId")
        protected String machineId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setRackId")
        protected String rackId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setSiteId")
        protected String siteId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setStrictPeerToPeer")
        protected Boolean strictPeerToPeer = true;
        @ConfigurationDoc(name="distributedSyncTimeout", desc="Infinispan uses a distributed lock to maintain a coherent transaction log during state transfer or rehashing, which means that only one cache can be doing state transfer or rehashing at the same time.This constraint is in place because more than one cache could be involved in a transaction.This timeout controls the time to wait to acquire acquire a lock on the distributed lock.")
        protected Long distributedSyncTimeout = 240000L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setTransportClass")
        protected String transportClass = null;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setTransportNodeName")
        protected String nodeName = null;
        @XmlElement(name="properties")
        protected TypedProperties properties = new TypedProperties();

        public TransportType() {
            this.transportClass = JGroupsTransport.class.getName();
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitTransportType(this);
        }

        public TransportType(String transportClass) {
            this.transportClass = transportClass;
        }

        @XmlAttribute
        public String getClusterName() {
            return this.clusterName;
        }

        @Deprecated
        public void setClusterName(String clusterName) {
            this.testImmutability("clusterName");
            this.clusterName = clusterName;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig clusterName(String clusterName) {
            this.setClusterName(clusterName);
            return this;
        }

        @XmlAttribute
        public String getMachineId() {
            return this.machineId;
        }

        @Deprecated
        public void setMachineId(String machineId) {
            this.testImmutability("machineId");
            this.machineId = machineId;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig machineId(String machineId) {
            this.setMachineId(machineId);
            return this;
        }

        @XmlAttribute
        public String getRackId() {
            return this.rackId;
        }

        @Deprecated
        public void setRackId(String rackId) {
            this.testImmutability("rackId");
            this.rackId = rackId;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig rackId(String rackId) {
            this.setRackId(rackId);
            return this;
        }

        @XmlAttribute
        public String getSiteId() {
            return this.siteId;
        }

        @Deprecated
        public void setSiteId(String siteId) {
            this.testImmutability("siteId");
            this.siteId = siteId;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig siteId(String siteId) {
            this.setSiteId(siteId);
            return this;
        }

        @XmlAttribute
        public Long getDistributedSyncTimeout() {
            return this.distributedSyncTimeout;
        }

        @Deprecated
        public void setDistributedSyncTimeout(Long distributedSyncTimeout) {
            this.testImmutability("distributedSyncTimeout");
            this.distributedSyncTimeout = distributedSyncTimeout;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig distributedSyncTimeout(Long distributedSyncTimeout) {
            this.setDistributedSyncTimeout(distributedSyncTimeout);
            return this;
        }

        @XmlAttribute
        public String getTransportClass() {
            return this.transportClass;
        }

        @Deprecated
        public void setTransportClass(String transportClass) {
            this.testImmutability("transportClass");
            this.transportClass = transportClass;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig transportClass(Class<? extends Transport> transportClass) {
            this.setTransportClass(transportClass == null ? null : transportClass.getName());
            return this;
        }

        @XmlAttribute
        public String getNodeName() {
            return this.nodeName;
        }

        @Deprecated
        public void setNodeName(String nodeName) {
            this.testImmutability("nodeName");
            this.nodeName = nodeName;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig nodeName(String nodeName) {
            this.setNodeName(nodeName);
            return this;
        }

        @Deprecated
        @XmlTransient
        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig withProperties(Properties properties) {
            this.setProperties(this.toTypedProperties(properties));
            return this;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        @XmlAttribute
        public Boolean getStrictPeerToPeer() {
            return this.strictPeerToPeer;
        }

        @Deprecated
        public void setStrictPeerToPeer(Boolean strictPeerToPeer) {
            this.testImmutability("strictPeerToPeer");
            this.strictPeerToPeer = strictPeerToPeer;
        }

        @Override
        public FluentGlobalConfiguration.TransportConfig strictPeerToPeer(Boolean strictPeerToPeer) {
            this.setStrictPeerToPeer(strictPeerToPeer);
            return this;
        }

        @Override
        public TransportType clone() throws CloneNotSupportedException {
            TransportType dolly = (TransportType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }

        @Override
        TransportType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            super.setGlobalConfiguration(globalConfig);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDocs(value={@ConfigurationDoc(name="evictionScheduledExecutor", desc="Configuration for the scheduled executor service used to periodically run eviction cleanup tasks."), @ConfigurationDoc(name="replicationQueueScheduledExecutor", desc="Configuration for the scheduled executor service used to periodically flush replication queues, used if asynchronous clustering is enabled along with useReplQueue being set to true.")})
    public static class ScheduledExecutorFactoryType
    extends FactoryClassWithPropertiesType
    implements FluentGlobalConfiguration.ExecutorFactoryConfig<ScheduledExecutorFactory> {
        private static final long serialVersionUID = 7806391452092647488L;
        @ConfigurationDoc(name="factory", desc="Fully qualified class name of the ScheduledExecutorFactory to use.  Must implement org.infinispan.executors.ScheduledExecutorFactory")
        protected String factory = DefaultScheduledExecutorFactory.class.getName();

        public ScheduledExecutorFactoryType(String factory) {
            this.factory = factory;
        }

        public ScheduledExecutorFactoryType() {
        }

        @XmlAttribute
        public String getFactory() {
            return this.factory;
        }

        public void setFactory(String factory) {
            this.testImmutability("factory");
            this.factory = factory;
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ScheduledExecutorFactory> factory(Class<? extends ScheduledExecutorFactory> clazz) {
            this.setFactory(clazz == null ? null : clazz.getName());
            return this;
        }

        @Override
        public ScheduledExecutorFactoryType clone() throws CloneNotSupportedException {
            return (ScheduledExecutorFactoryType)super.clone();
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ScheduledExecutorFactory> addProperty(String key, String value) {
            super.addProperty(key, value);
            return this;
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ScheduledExecutorFactory> withProperties(Properties props) {
            super.withProperties(props);
            return this;
        }

        @Override
        ScheduledExecutorFactoryType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            super.setGlobalConfiguration(globalConfig);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDocs(value={@ConfigurationDoc(name="asyncListenerExecutor", desc="Configuration for the executor service used to emit notifications to asynchronous listeners"), @ConfigurationDoc(name="asyncTransportExecutor", desc="Configuration for the executor service used for asynchronous work on the Transport, including asynchronous marshalling and Cache 'async operations' such as Cache.putAsync().")})
    public static class ExecutorFactoryType
    extends FactoryClassWithPropertiesType
    implements FluentGlobalConfiguration.ExecutorFactoryConfig<ExecutorFactory> {
        private static final long serialVersionUID = 6895901500645539386L;
        @ConfigurationDoc(name="factory", desc="Fully qualified class name of the ExecutorFactory to use.  Must implement org.infinispan.executors.ExecutorFactory")
        protected String factory = DefaultExecutorFactory.class.getName();

        public ExecutorFactoryType(String factory) {
            this.factory = factory;
        }

        public ExecutorFactoryType() {
        }

        @XmlAttribute
        public String getFactory() {
            return this.factory;
        }

        public void setFactory(String factory) {
            this.testImmutability("factory");
            this.factory = factory;
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ExecutorFactory> factory(Class<? extends ExecutorFactory> clazz) {
            this.setFactory(clazz == null ? null : clazz.getName());
            return this;
        }

        @Override
        public ExecutorFactoryType clone() throws CloneNotSupportedException {
            return (ExecutorFactoryType)super.clone();
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ExecutorFactory> addProperty(String key, String value) {
            super.addProperty(key, value);
            return this;
        }

        @Override
        public FluentGlobalConfiguration.ExecutorFactoryConfig<ExecutorFactory> withProperties(Properties props) {
            super.withProperties(props);
            return this;
        }

        @Override
        ExecutorFactoryType setGlobalConfiguration(GlobalConfiguration globalConfig) {
            super.setGlobalConfiguration(globalConfig);
            return this;
        }
    }

    public static abstract class FactoryClassWithPropertiesType
    extends AbstractConfigurationBeanWithGCR {
        private static final long serialVersionUID = 7625606997888180254L;
        @ConfigurationDocs(value={@ConfigurationDoc(name="maxThreads", desc="Maximum number of threads for this executor. Default values can be found <a href=&quot;http://community.jboss.org/docs/DOC-15540&quot;>here</a>"), @ConfigurationDoc(name="threadNamePrefix", desc="Thread name prefix for threads created by this executor. Default values can be found <a href=&quot;http://community.jboss.org/docs/DOC-15540&quot;>here</a>")})
        protected TypedProperties properties = new TypedProperties();

        public void accept(ConfigurationBeanVisitor v) {
            v.visitFactoryClassWithPropertiesType(this);
        }

        @Deprecated
        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        public Object addProperty(String key, String value) {
            this.properties.setProperty(key, value);
            return this;
        }

        public Object withProperties(Properties props) {
            this.properties.putAll((Map<?, ?>)props);
            return this;
        }

        @XmlElement(name="properties")
        public TypedProperties getProperties() {
            return this.properties;
        }

        @Override
        public FactoryClassWithPropertiesType clone() throws CloneNotSupportedException {
            FactoryClassWithPropertiesType dolly = (FactoryClassWithPropertiesType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }
    }

    public static enum ShutdownHookBehavior {
        DEFAULT,
        REGISTER,
        DONT_REGISTER;

    }
}

