/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.XAException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionCoordinator {
    private static final Log log = LogFactory.getLog(TransactionCoordinator.class);
    private CommandsFactory commandsFactory;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private TransactionTable txTable;
    private Configuration configuration;
    private RpcManager rpcManager;
    boolean trace;

    @Inject
    public void init(CommandsFactory commandsFactory, InvocationContextContainer icc, InterceptorChain invoker, TransactionTable txTable, Configuration configuration, RpcManager rpcManager) {
        this.commandsFactory = commandsFactory;
        this.icc = icc;
        this.invoker = invoker;
        this.txTable = txTable;
        this.configuration = configuration;
        this.trace = log.isTraceEnabled();
        this.rpcManager = rpcManager;
    }

    public int prepare(LocalTransaction localTransaction) throws XAException {
        this.validateNotMarkedForRollback(localTransaction);
        if (this.configuration.isOnePhaseCommit()) {
            if (this.trace) {
                log.tracef("Received prepare for tx: %s. Skipping call as 1PC will be used.", localTransaction);
            }
            return 0;
        }
        PrepareCommand prepareCommand = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), this.configuration.isOnePhaseCommit());
        if (this.trace) {
            log.tracef("Sending prepare command through the chain: %s", prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, prepareCommand);
            if (localTransaction.isReadOnly()) {
                if (this.trace) {
                    log.tracef("Readonly transaction: %s", localTransaction.getGlobalTransaction());
                }
                this.commit(localTransaction, false);
                return 3;
            }
            this.txTable.localTransactionPrepared(localTransaction);
            return 0;
        }
        catch (Throwable e) {
            log.error("Error while processing PrepareCommand", e);
            this.rollback(localTransaction);
            throw new XAException(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(LocalTransaction localTransaction, boolean isOnePhase) throws XAException {
        block10: {
            if (this.trace) {
                log.tracef("Committing transaction %s", localTransaction.getGlobalTransaction());
            }
            try {
                LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
                ctx.setLocalTransaction(localTransaction);
                if (this.configuration.isOnePhaseCommit() || isOnePhase) {
                    this.validateNotMarkedForRollback(localTransaction);
                    if (this.trace) {
                        log.trace("Doing an 1PC prepare call on the interceptor chain");
                    }
                    PrepareCommand command = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true);
                    try {
                        this.invoker.invoke(ctx, command);
                        this.txTable.removeLocalTransaction(localTransaction);
                        break block10;
                    }
                    catch (Throwable e) {
                        this.txTable.failureCompletingTransaction(ctx.getTransaction());
                        log.errorProcessing1pcPrepareCommand(e);
                        throw new XAException(-3);
                    }
                }
                this.handleTopologyChanges(localTransaction);
                CommitCommand commitCommand = this.commandsFactory.buildCommitCommand(localTransaction.getGlobalTransaction());
                try {
                    this.invoker.invoke(ctx, commitCommand);
                    this.txTable.removeLocalTransaction(localTransaction);
                }
                catch (Throwable e) {
                    this.txTable.failureCompletingTransaction(ctx.getTransaction());
                    log.errorProcessing1pcPrepareCommand(e);
                    throw new XAException(-3);
                }
            }
            finally {
                this.icc.suspend();
            }
        }
    }

    public void rollback(LocalTransaction localTransaction) throws XAException {
        if (this.trace) {
            log.tracef("rollback transaction %s ", localTransaction.getGlobalTransaction());
        }
        RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, rollbackCommand);
            this.txTable.removeLocalTransaction(localTransaction);
        }
        catch (Throwable e) {
            this.txTable.failureCompletingTransaction(ctx.getTransaction());
            log.errorRollingBack(e);
            throw new XAException(8);
        }
        finally {
            this.icc.suspend();
        }
    }

    private void validateNotMarkedForRollback(LocalTransaction localTransaction) throws XAException {
        if (localTransaction.isMarkedForRollback()) {
            if (this.trace) {
                log.tracef("Transaction already marked for rollback. Forcing rollback for %s", localTransaction);
            }
            this.rollback(localTransaction);
            throw new XAException(100);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTopologyChanges(LocalTransaction localTransaction) throws XAException {
        Collection<Address> preparedNodes = localTransaction.getRemoteLocksAcquired();
        List<Address> members = this.getClusterMembers();
        if (!members.containsAll(preparedNodes)) {
            if (this.trace) {
                log.tracef("Member(s) left, so re-applying prepare for %s", localTransaction);
            }
            localTransaction.filterRemoteLocksAcquire(members);
            try {
                this.prepare(localTransaction);
                return;
            }
            catch (XAException e) {
                if (this.configuration.isTransactionRecoveryEnabled()) return;
                this.rollback(localTransaction);
                throw new XAException(100);
            }
        } else {
            if (!this.trace) return;
            log.trace("All prepared nodes are okay.");
        }
    }

    private List<Address> getClusterMembers() {
        return this.rpcManager != null ? this.rpcManager.getTransport().getMembers() : Collections.emptyList();
    }
}

