/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.util.EnumerationList;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class FileLookup {
    private static final Log log = LogFactory.getLog(FileLookup.class);

    public InputStream lookupFile(String filename, ClassLoader cl) {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename, cl);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Unable to find file %s in classpath; searching for this file on the filesystem instead.", filename);
            }
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    public InputStream lookupFileStrict(String filename, ClassLoader cl) throws FileNotFoundException {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename, cl);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Unable to find file %s in classpath; searching for this file on the filesystem instead.", filename);
            }
            return new FileInputStream(filename);
        }
        return is;
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename, ClassLoader appClassLoader) {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = Util.getClassLoaders(appClassLoader)) {
            if (cl == null) continue;
            try {
                return cl.getResourceAsStream(filename);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected URL getAsURLFromClassLoader(String filename, ClassLoader userClassLoader) {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = new ClassLoader[]{userClassLoader, Util.class.getClassLoader(), ClassLoader.getSystemClassLoader()}) {
            if (cl == null) continue;
            try {
                return cl.getResource(filename);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected Collection<URL> getAsURLsFromClassLoader(String filename, ClassLoader userClassLoader) throws IOException {
        ClassLoader[] cls = new ClassLoader[]{userClassLoader, Util.class.getClassLoader(), ClassLoader.getSystemClassLoader()};
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader cl : cls) {
            if (cl == null) continue;
            try {
                urls.addAll(new EnumerationList<URL>(cl.getResources(filename)));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return urls;
    }

    public URL lookupFileLocation(String filename, ClassLoader cl) {
        File f;
        URL u = this.getAsURLFromClassLoader(filename, cl);
        if (u == null && (f = new File(filename)).exists()) {
            try {
                u = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return u;
    }

    public Collection<URL> lookupFileLocations(String filename, ClassLoader cl) throws IOException {
        Collection<URL> u = this.getAsURLsFromClassLoader(filename, cl);
        File f = new File(filename);
        if (f.exists()) {
            try {
                u.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return u;
    }
}

