/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.FragmentRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResolverException;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.resolver.felix.LoggerDelegate;
import org.jboss.osgi.resolver.felix.ModuleExt;
import org.jboss.osgi.resolver.felix.ResolverExt;
import org.jboss.osgi.resolver.felix.ResolverStateExt;
import org.jboss.osgi.resolver.felix.ResultProcessor;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractResolver;

public class FelixResolver
extends AbstractResolver
implements XResolver {
    private Logger logger = new LoggerDelegate();
    private ResolverExt resolver = new ResolverExt(this.logger);
    private ResolverStateExt resolverState = new ResolverStateExt(this.logger);
    private ResultProcessor resultProcessor = new ResultProcessor(this);

    public void addModule(XModule module) {
        super.addModule(module);
        ModuleExt fmod = new ModuleExt((AbstractModule)module);
        module.addAttachment(ModuleExt.class, (Object)fmod);
        this.resolverState.addModule(fmod);
    }

    public void removeModule(XModule module) {
        super.removeModule(module);
        ModuleExt fmod = (ModuleExt)module.getAttachment(ModuleExt.class);
        if (fmod != null) {
            this.resolverState.removeModule(fmod);
        }
    }

    public ModuleExt findHost(ModuleExt fragModule) {
        ModuleExt hostModule = (ModuleExt)this.resolverState.findHost(fragModule);
        return hostModule;
    }

    public List<ModuleExt> findFragments(ModuleExt hostModule) {
        ArrayList<ModuleExt> frags = new ArrayList<ModuleExt>();
        for (Module m : this.resolverState.findFragments(hostModule)) {
            frags.add((ModuleExt)m);
        }
        return frags;
    }

    protected void setResolved(AbstractModule module) {
        super.setResolved(module);
    }

    protected void resolveInternal(XModule module) throws XResolverException {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        ModuleExt rootModule = (ModuleExt)module.getAttachment(ModuleExt.class);
        try {
            this.resolveInternal(rootModule);
        }
        catch (ResolveException ex) {
            String msg = ex.getMessage();
            ModuleExt exmod = (ModuleExt)ex.getModule();
            Requirement exreq = ex.getRequirement();
            Throwable cause = ex.getCause();
            XResolverException resex = new XResolverException(msg, (XModule)exmod.getModule(), (Object)exreq);
            resex.initCause(cause);
            throw resex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveInternal(ModuleExt rootModule) {
        if (!rootModule.isResolved()) {
            ResolverStateExt resolverStateExt = this.resolverState;
            synchronized (resolverStateExt) {
                Module newRootModule = this.resolverState.findHost(rootModule);
                if (!Util.isFragment(newRootModule)) {
                    boolean repeat;
                    this.resolverState.checkSingleton(newRootModule);
                    do {
                        repeat = false;
                        try {
                            Map<Module, List<Wire>> wireMap = this.resolver.resolve(this.resolverState, newRootModule);
                            this.markResolvedModules(wireMap);
                        }
                        catch (ResolveException ex) {
                            Requirement req = ex.getRequirement();
                            if (req != null && req instanceof FragmentRequirement && rootModule != ((FragmentRequirement)req).getFragment()) {
                                this.resolverState.detachFragment(newRootModule, ((FragmentRequirement)req).getFragment());
                                repeat = true;
                                continue;
                            }
                            throw ex;
                        }
                    } while (repeat);
                }
            }
        }
    }

    private void markResolvedModules(Map<Module, List<Wire>> wireMap) {
        if (wireMap != null) {
            for (Map.Entry<Module, List<Wire>> entry : wireMap.entrySet()) {
                ModuleExt moduleExt = (ModuleExt)entry.getKey();
                List<Wire> wires = entry.getValue();
                for (int wireIdx = 0; wireIdx < wires.size(); ++wireIdx) {
                    this.logger.log(4, "WIRE: " + wires.get(wireIdx));
                }
                this.resultProcessor.setModuleWires(moduleExt, wires);
                List<Module> fragments = moduleExt.getFragments();
                for (int i = 0; fragments != null && i < fragments.size(); ++i) {
                    ModuleExt frag = (ModuleExt)fragments.get(i);
                    frag.setResolved();
                    this.resultProcessor.setModuleWires(frag, null);
                    this.resultProcessor.setResolved(frag);
                    this.logger.log(4, "FRAGMENT WIRE: " + frag + " -> hosted by -> " + moduleExt);
                }
                this.resultProcessor.setResolved(moduleExt);
                this.resolverState.moduleResolved(moduleExt);
            }
        }
    }

    protected XWire addWire(AbstractModule importer, XRequirement requirement, XModule exporter, XCapability capability) {
        return super.addWire(importer, requirement, exporter, capability);
    }
}

