/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDependencyProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.moduleservice.ModuleIndexService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;

public class JaxrsScanningProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jaxrs");
    public static final DotName APPLICATION = DotName.createSimple((String)Application.class.getName());
    private static final ModuleIdentifier[] JAXRS_MODULES_TO_SCAN = new ModuleIdentifier[]{JaxrsDependencyProcessor.RESTEASY_JAXRS, JaxrsDependencyProcessor.RESTEASY_JAXB, JaxrsDependencyProcessor.RESTEASY_ATOM, JaxrsDependencyProcessor.RESTEASY_JSAPI, JaxrsDependencyProcessor.RESTEASY_JACKSON, JaxrsDependencyProcessor.RESTEASY_MULTIPART};
    private static CompositeIndex[] EMPTY_INDEXES = new CompositeIndex[0];
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map deploymentData;
        DeploymentUnit parent;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        if (deploymentUnit.getParent() == null) {
            deploymentData = Collections.synchronizedMap(new HashMap());
            deploymentUnit.putAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA, (Object)deploymentData);
        } else {
            deploymentData = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        }
        ModuleIdentifier moduleIdentifier = (ModuleIdentifier)deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        ResteasyDeploymentData resteasyDeploymentData = new ResteasyDeploymentData();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServiceController serviceController = phaseContext.getServiceRegistry().getRequiredService(Services.JBOSS_MODULE_INDEX_SERVICE);
        try {
            if (warMetaData == null) {
                resteasyDeploymentData.setScanAll(true);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), resteasyDeploymentData, (ModuleIndexService)serviceController.getValue(), false);
                deploymentData.put(moduleIdentifier, resteasyDeploymentData);
            } else {
                this.scanWebDeployment(deploymentUnit, warMetaData.getMergedJBossWebMetaData(), (ClassLoader)module.getClassLoader(), resteasyDeploymentData);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), resteasyDeploymentData, (ModuleIndexService)serviceController.getValue(), true);
            }
            deploymentUnit.putAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA, (Object)resteasyDeploymentData);
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected boolean hasBootClasses(JBossWebMetaData webdata) throws DeploymentUnitProcessingException {
        if (webdata.getServlets() != null) {
            for (JBossServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected void scanWebDeployment(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException {
        List contextParams;
        boolean hasBoot = this.hasBootClasses(webdata);
        resteasyDeploymentData.setBootClasses(hasBoot);
        Class<?> declaredApplicationClass = this.checkDeclaredApplicationClassAsServlet(du, webdata, classLoader);
        if (declaredApplicationClass != null) {
            resteasyDeploymentData.setDispatcherCreated(true);
        }
        if (!hasBoot && !webdata.isMetadataComplete()) {
            resteasyDeploymentData.setScanAll(true);
            resteasyDeploymentData.setScanProviders(true);
            resteasyDeploymentData.setScanResources(true);
        }
        if ((contextParams = webdata.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    resteasyDeploymentData.setScanAll(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    resteasyDeploymentData.setScanProviders(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    resteasyDeploymentData.setScanResources(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (!param.getParamName().equals("resteasy.unwrapped.exceptions")) continue;
                resteasyDeploymentData.setUnwrappedExceptionsParameterSet(true);
            }
        }
    }

    protected void scan(DeploymentUnit du, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData, ModuleIndexService moduleIndexService, boolean webDeployment) throws DeploymentUnitProcessingException, ModuleLoadException {
        ClassInfo info;
        ServiceModuleLoader moduleLoader = (ServiceModuleLoader)du.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ArrayList<Object> indexes = new ArrayList<Object>();
        if (webDeployment) {
            for (ModuleIdentifier moduleIdentifier : JAXRS_MODULES_TO_SCAN) {
                Module resteasy = moduleLoader.loadModule(moduleIdentifier);
                indexes.add(moduleIndexService.getIndex(resteasy));
            }
        }
        indexes.add(du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX));
        CompositeIndex index = new CompositeIndex(indexes.toArray(EMPTY_INDEXES));
        if (!resteasyDeploymentData.shouldScan()) {
            return;
        }
        Set applicationClass = index.getAllKnownSubclasses(APPLICATION);
        try {
            if (applicationClass.size() > 1) {
                StringBuilder builder = new StringBuilder("Only one JAX-RS Application Class allowed.");
                HashSet<ClassInfo> aClasses = new HashSet<ClassInfo>();
                for (ClassInfo c : applicationClass) {
                    if (!Modifier.isAbstract(c.flags())) {
                        aClasses.add(c);
                    }
                    builder.append(" ").append(c.name().toString());
                }
                if (aClasses.size() > 1) {
                    throw new DeploymentUnitProcessingException(builder.toString());
                }
                if (aClasses.size() == 1) {
                    ClassInfo aClass = (ClassInfo)applicationClass.iterator().next();
                    resteasyDeploymentData.setScannedApplicationClass(classLoader.loadClass(aClass.name().toString()));
                }
            } else if (applicationClass.size() == 1) {
                ClassInfo aClass = (ClassInfo)applicationClass.iterator().next();
                resteasyDeploymentData.setScannedApplicationClass(classLoader.loadClass(aClass.name().toString()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load JAX-RS Application class:", (Throwable)e);
        }
        List resources = null;
        List providers = null;
        if (resteasyDeploymentData.isScanResources()) {
            resources = index.getAnnotations(JaxrsAnnotations.PATH.getDotName());
        }
        if (resteasyDeploymentData.isScanProviders()) {
            providers = index.getAnnotations(JaxrsAnnotations.PROVIDER.getDotName());
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        HashSet<ClassInfo> pathInterfaces = new HashSet<ClassInfo>();
        if (resources != null) {
            for (AnnotationInstance e : resources) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                } else if (e.target() instanceof MethodInfo) {
                    info = ((MethodInfo)e.target()).declaringClass();
                } else {
                    log.warnf("@Path annotation not on Class or Method: %s", (Object)e.target());
                    continue;
                }
                if (!Modifier.isInterface(info.flags())) {
                    resteasyDeploymentData.getScannedResourceClasses().add(info.name().toString());
                    continue;
                }
                pathInterfaces.add(info);
            }
        }
        if (providers != null) {
            for (AnnotationInstance e : providers) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                    if (Modifier.isInterface(info.flags())) continue;
                    resteasyDeploymentData.getScannedProviderClasses().add(info.name().toString());
                    continue;
                }
                log.warnf("@Provider annotation not on Class: %s", (Object)e.target());
            }
        }
        for (ClassInfo iface : pathInterfaces) {
            Set implementors = index.getAllKnownImplementors(iface.name());
            for (ClassInfo implementor : implementors) {
                resteasyDeploymentData.getScannedResourceClasses().add(implementor.name().toString());
            }
        }
    }

    protected Class<?> checkDeclaredApplicationClassAsServlet(DeploymentUnit du, JBossWebMetaData webData, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        if (webData.getServlets() == null) {
            return null;
        }
        for (JBossServletMetaData servlet : webData.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            return clazz;
        }
        return null;
    }

    static {
        for (String clazz : ResteasyBootstrapClasses.BOOTSTRAP_CLASSES) {
            BOOT_CLASSES.add(clazz);
        }
    }
}

