/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.PropertiesBootstrapProvider;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.kohsuke.args4j.Option;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class OSGiBootstrapBean {
    private static Logger log;
    private static final String JAVA_PROTOCOL_HANDLERS = "java.protocol.handler.pkgs";
    private static final String DEFAULT_JAVA_PROTOCOL_HANDLERS = "org.jboss.net.protocol|org.jboss.virtual.protocol|org.jboss.vfs.protocol";
    private static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String OSGI_SERVER_NAME = "osgi.server.name";
    @Option(name="-c", aliases={"--server-name"}, usage="The runtime profile to start. (-c minimal)", required=false)
    public String serverName = "default";
    @Option(name="-b", aliases={"--bind-address"}, usage="The network address various services can bind to (-b 127.0.0.1)", required=false)
    public String bindAddress = "localhost";
    private String osgiHome;
    private String osgiServerHome;

    public void run() {
        this.initBootstrap();
        OSGiBootstrapProvider bootProvider = OSGiBootstrapBean.getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new ShutdownThread(framework));
        StartupThread thread = new StartupThread(framework);
        thread.start();
    }

    private void initBootstrap() {
        this.osgiHome = System.getProperty("osgi.home");
        if (this.osgiHome == null) {
            throw new IllegalStateException("Cannot obtain system property: 'osgi.home'");
        }
        this.osgiServerHome = this.osgiHome + "/server/" + this.serverName;
        File serverConfDir = new File(this.osgiServerHome + "/conf");
        if (serverConfDir.exists()) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader confLoader = new URLClassLoader(new URL[]{this.toURL(serverConfDir)}, ctxLoader);
            Thread.currentThread().setContextClassLoader(confLoader);
        }
        System.setProperty("osgi.server.home", this.osgiServerHome);
        log = Logger.getLogger(OSGiBootstrapBean.class);
        Properties defaults = new Properties();
        defaults.setProperty(OSGI_SERVER_NAME, this.serverName);
        defaults.setProperty("osgi.server.home", this.osgiServerHome);
        defaults.setProperty(JBOSS_BIND_ADDRESS, this.bindAddress);
        defaults.setProperty(JAVA_PROTOCOL_HANDLERS, DEFAULT_JAVA_PROTOCOL_HANDLERS);
        log.debug((Object)"JBoss OSGi System Properties");
        log.debug((Object)("   osgi.server.home=" + this.osgiServerHome));
        Enumeration<?> defaultNames = defaults.propertyNames();
        while (defaultNames.hasMoreElements()) {
            String propName = (String)defaultNames.nextElement();
            String sysValue = System.getProperty(propName);
            if (sysValue != null) continue;
            String propValue = defaults.getProperty(propName);
            System.setProperty(propName, propValue);
            log.debug((Object)("   " + propName + "=" + propValue));
        }
    }

    public static OSGiBootstrapProvider getBootstrapProvider() {
        if (log == null) {
            log = Logger.getLogger(OSGiBootstrap.class);
        }
        OSGiBootstrapProvider provider = null;
        List<OSGiBootstrapProvider> providers = ServiceLoader.loadServices(OSGiBootstrapProvider.class);
        for (OSGiBootstrapProvider aux : providers) {
            try {
                aux.configure();
                provider = aux;
                break;
            }
            catch (Exception ex) {
                log.debug((Object)("Cannot configure [" + aux.getClass().getName() + "]"), (Throwable)ex);
            }
        }
        if (provider == null) {
            provider = new PropertiesBootstrapProvider();
            log.debug((Object)("Using default: " + PropertiesBootstrapProvider.class.getName()));
        }
        return provider;
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
    }

    class ShutdownThread
    extends Thread {
        private Framework framework;

        public ShutdownThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            log.info((Object)"Initiating shutdown ...");
            try {
                this.framework.stop();
                this.framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot stop framework", (Throwable)ex);
            }
            log.info((Object)"Shutdown complete");
        }
    }

    class StartupThread
    extends Thread {
        private Framework framework;

        public StartupThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            long beforeStart = System.currentTimeMillis();
            try {
                this.framework.start();
            }
            catch (BundleException ex) {
                throw new IllegalStateException("Cannot start framework", ex);
            }
            float diff = (float)(System.currentTimeMillis() - beforeStart) / 1000.0f;
            log.info((Object)("JBossOSGi Runtime booted in " + diff + "sec"));
            InputStreamReader br = new InputStreamReader(System.in);
            try {
                int inByte = ((Reader)br).read();
                while (inByte != -1) {
                    inByte = ((Reader)br).read();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

