/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.util.Base64;

public class SecretIdentityService
implements Service<CallbackHandlerFactory> {
    public static final String SERVICE_SUFFIX = "secret";
    private final char[] password;
    private CallbackHandlerFactory factory;

    public SecretIdentityService(String base64Password) {
        byte[] value = Base64.decode((String)base64Password);
        this.password = new String(value).toCharArray();
    }

    public void start(StartContext startContext) throws StartException {
        this.factory = new CallbackHandlerFactory(){

            @Override
            public CallbackHandler getCallbackHandler(String username) {
                return new SecretCallbackHandler(username);
            }
        };
    }

    public void stop(StopContext stopContext) {
        this.factory = null;
    }

    public CallbackHandlerFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.factory;
    }

    private class SecretCallbackHandler
    implements CallbackHandler {
        private final String userName;

        SecretCallbackHandler(String userName) {
            this.userName = userName;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(SecretIdentityService.this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

