/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.util;

public class HexUtil {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String convertToHexString(byte[] toBeConverted) {
        if (toBeConverted == null) {
            throw new NullPointerException("Parameter to be converted can not be null");
        }
        char[] converted = new char[toBeConverted.length * 2];
        for (int i = 0; i < toBeConverted.length; ++i) {
            byte b = toBeConverted[i];
            converted[i * 2] = HEX_CHARS[b >> 4 & 0xF];
            converted[i * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return String.valueOf(converted);
    }

    public static byte[] convertToHexBytes(byte[] toBeConverted) {
        if (toBeConverted == null) {
            throw new NullPointerException("Parameter to be converted can not be null");
        }
        byte[] converted = new byte[toBeConverted.length * 2];
        for (int i = 0; i < toBeConverted.length; ++i) {
            byte b = toBeConverted[i];
            converted[i * 2] = HEX_BYTES[b >> 4 & 0xF];
            converted[i * 2 + 1] = HEX_BYTES[b & 0xF];
        }
        return converted;
    }

    public static void main(String[] args) {
        byte[] toConvert = new byte[256];
        for (int i = 0; i < toConvert.length; ++i) {
            toConvert[i] = (byte)i;
        }
        System.out.println("Converted - " + HexUtil.convertToHexString(toConvert));
    }
}

