/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemModuleProvider;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemPackagesPlugin;

final class DefaultSystemModuleProvider
extends AbstractPluginService<Module>
implements SystemModuleProvider {
    private static final ModuleIdentifier SYSTEM_MODULE_IDENTIFIER = ModuleIdentifier.create((String)"jbosgi.system");
    final Logger log = Logger.getLogger(DefaultSystemModuleProvider.class);
    private final InjectedValue<SystemPackagesPlugin> injectedSystemPackages = new InjectedValue();
    private Module systemModule;

    static void addService(ServiceTarget serviceTarget) {
        DefaultSystemModuleProvider service = new DefaultSystemModuleProvider();
        ServiceBuilder builder = serviceTarget.addService(Services.SYSTEM_MODULE_PROVIDER, (Service)service);
        builder.addDependency(InternalServices.SYSTEM_PACKAGES_PLUGIN, SystemPackagesPlugin.class, service.injectedSystemPackages);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private DefaultSystemModuleProvider() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.systemModule = this.createSystemModule();
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.systemModule = null;
    }

    public Module getValue() {
        return this.systemModule;
    }

    Module getSystemModule() {
        return this.systemModule;
    }

    private Module createSystemModule() {
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)SYSTEM_MODULE_IDENTIFIER);
        ModuleLoader systemLoader = Module.getBootModuleLoader();
        ModuleIdentifier identifier = Module.getSystemModule().getIdentifier();
        PathFilter systemFilter = ((SystemPackagesPlugin)((Object)this.injectedSystemPackages.getValue())).getSystemPackageFilter();
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)systemFilter, (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemLoader, (ModuleIdentifier)identifier, (boolean)false));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
            return moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

