/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String ROOT_CONTEXT = "ROOT";
    private static final String CONTEXT_DELIMITER = ",";
    private static final String HOST_CONTEXT_DELIMITER = ":";
    private static final String DEFAULT_HOST = "localhost";
    private static final Logger log = Logger.getLogger(Utils.class);

    public static RuntimeException convertToUnchecked(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t.getMessage(), t);
    }

    public static InetSocketAddress parseSocketAddress(String addressPort, int defaultPort) throws UnknownHostException {
        int lastColon;
        String address = addressPort;
        int port = defaultPort;
        int n = lastColon = addressPort != null ? addressPort.lastIndexOf(HOST_CONTEXT_DELIMITER) : -1;
        if (lastColon >= 0) {
            if (addressPort.indexOf(HOST_CONTEXT_DELIMITER) == lastColon) {
                address = addressPort.substring(0, lastColon);
                port = Integer.parseInt(addressPort.substring(lastColon + 1));
            } else {
                int openBracket = addressPort.indexOf("[");
                int closeBracket = addressPort.indexOf("]");
                if (openBracket >= 0 && closeBracket >= 0) {
                    address = addressPort.substring(openBracket + 1, closeBracket);
                    if (closeBracket < lastColon) {
                        port = Integer.parseInt(addressPort.substring(lastColon + 1));
                    }
                }
            }
        }
        return new InetSocketAddress(address != null && address.length() > 0 ? InetAddress.getByName(address) : InetAddress.getLocalHost(), port);
    }

    public static List<InetSocketAddress> parseSocketAddresses(String addresses, int defaultPort) {
        if (addresses == null || addresses.length() == 0) {
            return Collections.emptyList();
        }
        String[] tokens = addresses.split(CONTEXT_DELIMITER);
        ArrayList<InetSocketAddress> proxies = new ArrayList<InetSocketAddress>(tokens.length);
        for (String token : tokens) {
            try {
                InetSocketAddress addressPort = Utils.parseSocketAddress(token.trim(), defaultPort);
                proxies.add(addressPort);
            }
            catch (UnknownHostException e) {
                log.error((Object)Strings.ERROR_HOST_INVALID.getString(token), (Throwable)e);
            }
        }
        return proxies;
    }

    public static Map<String, Set<String>> parseContexts(String contexts) {
        if (contexts == null) {
            return Collections.emptyMap();
        }
        String trimmedContexts = contexts.trim();
        if (trimmedContexts.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String context : trimmedContexts.split(CONTEXT_DELIMITER)) {
            String[] parts = context.trim().split(HOST_CONTEXT_DELIMITER);
            if (parts.length > 2) {
                throw new IllegalArgumentException(trimmedContexts + " is not a valid value for excludedContexts");
            }
            String host = DEFAULT_HOST;
            String trimmedContext = parts[0].trim();
            if (parts.length == 2) {
                host = trimmedContext;
                trimmedContext = parts[1].trim();
            }
            String path = trimmedContext.equals(ROOT_CONTEXT) ? "" : "/" + trimmedContext;
            HashSet<String> paths = (HashSet<String>)map.get(host);
            if (paths == null) {
                paths = new HashSet<String>();
                map.put(host, paths);
            }
            paths.add(path);
        }
        return map;
    }

    private Utils() {
    }
}

