/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.BioDatagramUdpChannel;

class BioMulticastUdpChannel
extends BioDatagramUdpChannel
implements MulticastMessageChannel {
    private final MulticastSocket multicastSocket;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.MULTICAST_TTL).create();

    BioMulticastUdpChannel(int sendBufSize, int recvBufSize, MulticastSocket multicastSocket) {
        super(sendBufSize, recvBufSize, multicastSocket);
        this.multicastSocket = multicastSocket;
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new BioKey(iface, group);
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOperationException("source filtering not supported");
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || super.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (Options.MULTICAST_TTL.equals(option)) {
            return (T)Integer.valueOf(this.multicastSocket.getTimeToLive());
        }
        return super.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (!Options.MULTICAST_TTL.equals(option)) {
            return super.setOption(option, value);
        }
        Integer old = this.multicastSocket.getTimeToLive();
        this.multicastSocket.setTimeToLive((Integer)value);
        return (T)option.cast((Object)old);
    }

    private final class BioKey
    implements MulticastMessageChannel.Key {
        private final AtomicBoolean openFlag = new AtomicBoolean(true);
        private final NetworkInterface networkInterface;
        private final InetAddress group;

        private BioKey(NetworkInterface networkInterface, InetAddress group) throws IOException {
            this.networkInterface = networkInterface;
            this.group = group;
            BioMulticastUdpChannel.this.multicastSocket.joinGroup(new InetSocketAddress(group, 0), networkInterface);
        }

        public MulticastMessageChannel.Key block(InetAddress source) throws IOException {
            throw new UnsupportedOperationException("source filtering not supported");
        }

        public MulticastMessageChannel.Key unblock(InetAddress source) throws IOException {
            return this;
        }

        public MulticastMessageChannel getChannel() {
            return BioMulticastUdpChannel.this;
        }

        public InetAddress getGroup() {
            return this.group;
        }

        public NetworkInterface getNetworkInterface() {
            return this.networkInterface;
        }

        public InetAddress getSourceAddress() {
            return null;
        }

        public boolean isOpen() {
            return this.openFlag.get();
        }

        public void close() throws IOException {
            if (this.openFlag.getAndSet(false)) {
                BioMulticastUdpChannel.this.multicastSocket.leaveGroup(new InetSocketAddress(this.group, 0), this.networkInterface);
            }
        }
    }
}

