/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.ExtensionRemoveHandler;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.operations.ConnectionAddHandler;
import org.jboss.as.domain.management.operations.SecurityRealmAddHandler;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentDeployHandler;
import org.jboss.as.server.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.server.deployment.DeploymentRedeployHandler;
import org.jboss.as.server.deployment.DeploymentRemoveHandler;
import org.jboss.as.server.deployment.DeploymentReplaceHandler;
import org.jboss.as.server.deployment.DeploymentStatusHandler;
import org.jboss.as.server.deployment.DeploymentUndeployHandler;
import org.jboss.as.server.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.server.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.server.deployment.DeploymentUploadURLHandler;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.as.server.operations.DumpServicesHandler;
import org.jboss.as.server.operations.ExtensionAddHandler;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.HttpManagementAttributeHandlers;
import org.jboss.as.server.operations.LaunchTypeHandler;
import org.jboss.as.server.operations.NativeManagementAddHandler;
import org.jboss.as.server.operations.NativeManagementAttributeHandlers;
import org.jboss.as.server.operations.ProcessTypeHandler;
import org.jboss.as.server.operations.ServerReloadHandler;
import org.jboss.as.server.operations.ServerShutdownHandler;
import org.jboss.as.server.operations.ServerStateAttributeHandler;
import org.jboss.as.server.operations.SpecifiedPathAddHandler;
import org.jboss.as.server.operations.SpecifiedPathRemoveHandler;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.as.server.services.net.BindingFixedPortHandler;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.BindingGroupDefaultInterfaceHandler;
import org.jboss.as.server.services.net.BindingGroupPortOffsetHandler;
import org.jboss.as.server.services.net.BindingInterfaceHandler;
import org.jboss.as.server.services.net.BindingMetricHandlers;
import org.jboss.as.server.services.net.BindingMulticastAddressHandler;
import org.jboss.as.server.services.net.BindingMulticastPortHandler;
import org.jboss.as.server.services.net.BindingPortHandler;
import org.jboss.as.server.services.net.BindingRemoveHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;

public class ServerControllerModelUtil {
    public static ModelNode createCoreModel() {
        ModelNode root = new ModelNode();
        ServerControllerModelUtil.updateCoreModel(root);
        return root;
    }

    public static void updateCoreModel(ModelNode root) {
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("name");
        root.get("core-service");
        root.get("profile-name");
        root.get("extension");
        root.get("system-property");
        root.get("path");
        root.get("subsystem");
        root.get("interface");
        root.get("socket-binding-group");
        root.get("deployment");
    }

    public static void initOperations(ManagementResourceRegistration root, ContentRepository contentRepository, ExtensibleConfigurationPersister extensibleConfigurationPersister, ServerEnvironment serverEnvironment, ControlledProcessState processState) {
        root.registerReadWriteAttribute("name", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        root.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true);
        root.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("validate-address", GlobalOperationHandlers.VALIDATE_ADDRESS, CommonProviders.VALIDATE_ADDRESS_PROVIDER, true);
        root.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)extensibleConfigurationPersister);
        root.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false);
        root.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        DeploymentUploadBytesHandler dubh = new DeploymentUploadBytesHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-bytes", (OperationStepHandler)dubh, (DescriptionProvider)dubh, false);
        DeploymentUploadURLHandler duuh = new DeploymentUploadURLHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-url", (OperationStepHandler)duuh, (DescriptionProvider)duuh, false);
        DeploymentUploadStreamAttachmentHandler dush = new DeploymentUploadStreamAttachmentHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-stream", (OperationStepHandler)dush, (DescriptionProvider)dush, false);
        DeploymentReplaceHandler drh = new DeploymentReplaceHandler(contentRepository);
        root.registerOperationHandler("replace-deployment", (OperationStepHandler)drh, (DescriptionProvider)drh, false);
        DeploymentFullReplaceHandler dfrh = new DeploymentFullReplaceHandler(contentRepository);
        root.registerOperationHandler("full-replace-deployment", (OperationStepHandler)dfrh, (DescriptionProvider)dfrh, false);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)extensibleConfigurationPersister);
        root.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)extensibleConfigurationPersister);
        root.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)extensibleConfigurationPersister);
        root.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        root.registerReadOnlyAttribute("server-state", (OperationStepHandler)new ServerStateAttributeHandler(processState), AttributeAccess.Storage.RUNTIME);
        root.registerReadOnlyAttribute("process-type", (OperationStepHandler)ProcessTypeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        if (serverEnvironment != null) {
            if (serverEnvironment.getLaunchType() != ServerEnvironment.LaunchType.DOMAIN) {
                root.registerOperationHandler("reload", (OperationStepHandler)ServerReloadHandler.INSTANCE, (DescriptionProvider)ServerReloadHandler.INSTANCE, false);
            }
            if (serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.STANDALONE) {
                root.registerOperationHandler("shutdown", (OperationStepHandler)ServerShutdownHandler.INSTANCE, (DescriptionProvider)ServerShutdownHandler.INSTANCE, false);
            }
            root.registerReadOnlyAttribute("launch-type", (OperationStepHandler)new LaunchTypeHandler(serverEnvironment.getLaunchType()), AttributeAccess.Storage.RUNTIME);
        }
        ManagementResourceRegistration sysProps = root.registerSubModel(PathElement.pathElement((String)"system-property"), ServerDescriptionProviders.SYSTEM_PROPERTIES_PROVIDER);
        sysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITHOUT_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITHOUT_BOOTTIME, false);
        sysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        sysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration management = root.registerSubModel(PathElement.pathElement((String)"core-service", (String)"management"), CommonProviders.MANAGEMENT_WITH_INTERFACES_PROVIDER);
        ManagementResourceRegistration securityRealm = management.registerSubModel(PathElement.pathElement((String)"security-realm"), CommonProviders.MANAGEMENT_SECURITY_REALM_PROVIDER);
        securityRealm.registerOperationHandler("add", (OperationStepHandler)SecurityRealmAddHandler.INSTANCE, (DescriptionProvider)SecurityRealmAddHandler.INSTANCE, false);
        ManagementResourceRegistration connection = management.registerSubModel(PathElement.pathElement((String)"outbound-connection"), CommonProviders.MANAGEMENT_OUTBOUND_CONNECTION_PROVIDER);
        connection.registerOperationHandler("add", (OperationStepHandler)ConnectionAddHandler.INSTANCE, (DescriptionProvider)ConnectionAddHandler.INSTANCE, false);
        ManagementResourceRegistration managementNative = management.registerSubModel(PathElement.pathElement((String)"management-interface", (String)"native-interface"), CommonProviders.NATIVE_MANAGEMENT_PROVIDER);
        managementNative.registerOperationHandler("add", (OperationStepHandler)NativeManagementAddHandler.INSTANCE, (DescriptionProvider)NativeManagementAddHandler.INSTANCE, false);
        managementNative.registerReadWriteAttribute("security-realm", null, NativeManagementAttributeHandlers.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration managementHttp = management.registerSubModel(PathElement.pathElement((String)"management-interface", (String)"http-interface"), CommonProviders.HTTP_MANAGEMENT_PROVIDER);
        managementHttp.registerOperationHandler("add", (OperationStepHandler)HttpManagementAddHandler.INSTANCE, (DescriptionProvider)HttpManagementAddHandler.INSTANCE, false);
        managementHttp.registerReadWriteAttribute("security-realm", null, HttpManagementAttributeHandlers.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration serviceContainer = root.registerSubModel(PathElement.pathElement((String)"core-service", (String)"service-container"), CommonProviders.SERVICE_CONTAINER_PROVIDER);
        serviceContainer.registerOperationHandler("dump-services", (OperationStepHandler)DumpServicesHandler.INSTANCE, (DescriptionProvider)DumpServicesHandler.INSTANCE, false);
        ManagementResourceRegistration paths = root.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationStepHandler)SpecifiedPathAddHandler.INSTANCE, (DescriptionProvider)SpecifiedPathAddHandler.INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationStepHandler)SpecifiedPathRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedPathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationStepHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration socketGroup = root.registerSubModel(PathElement.pathElement((String)"socket-binding-group"), ServerDescriptionProviders.SOCKET_BINDING_GROUP_PROVIDER);
        socketGroup.registerOperationHandler("add", (OperationStepHandler)BindingGroupAddHandler.INSTANCE, (DescriptionProvider)BindingGroupAddHandler.INSTANCE, false);
        socketGroup.registerOperationHandler("remove", (OperationStepHandler)SocketBindingGroupRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupRemoveHandler.INSTANCE, false);
        socketGroup.registerReadWriteAttribute("port-offset", null, (OperationStepHandler)BindingGroupPortOffsetHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketGroup.registerReadWriteAttribute("default-interface", null, (OperationStepHandler)BindingGroupDefaultInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration socketBinding = socketGroup.registerSubModel(PathElement.pathElement((String)"socket-binding"), CommonProviders.SOCKET_BINDING_PROVIDER);
        socketBinding.registerOperationHandler("add", (OperationStepHandler)BindingAddHandler.INSTANCE, (DescriptionProvider)BindingAddHandler.INSTANCE, false);
        socketBinding.registerOperationHandler("remove", (OperationStepHandler)BindingRemoveHandler.INSTANCE, (DescriptionProvider)BindingRemoveHandler.INSTANCE, false);
        socketBinding.registerMetric("bound", BindingMetricHandlers.BoundHandler.INSTANCE);
        socketBinding.registerMetric("bound-address", BindingMetricHandlers.BoundAddressHandler.INSTANCE);
        socketBinding.registerMetric("bound-port", BindingMetricHandlers.BoundPortHandler.INSTANCE);
        socketBinding.registerReadWriteAttribute("interface", null, (OperationStepHandler)BindingInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("port", null, (OperationStepHandler)BindingPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("fixed-port", null, (OperationStepHandler)BindingFixedPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-address", null, (OperationStepHandler)BindingMulticastAddressHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-port", null, (OperationStepHandler)BindingMulticastPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = new DeploymentAddHandler(contentRepository);
        deployments.registerOperationHandler("add", (OperationStepHandler)dah, (DescriptionProvider)dah, false);
        deployments.registerOperationHandler("remove", (OperationStepHandler)DeploymentRemoveHandler.INSTANCE, (DescriptionProvider)DeploymentRemoveHandler.INSTANCE, false);
        deployments.registerOperationHandler("deploy", (OperationStepHandler)DeploymentDeployHandler.INSTANCE, (DescriptionProvider)DeploymentDeployHandler.INSTANCE, false);
        deployments.registerOperationHandler("undeploy", (OperationStepHandler)DeploymentUndeployHandler.INSTANCE, (DescriptionProvider)DeploymentUndeployHandler.INSTANCE, false);
        deployments.registerOperationHandler("redeploy", (OperationStepHandler)DeploymentRedeployHandler.INSTANCE, (DescriptionProvider)DeploymentRedeployHandler.INSTANCE, false);
        deployments.registerMetric("status", DeploymentStatusHandler.INSTANCE);
        deployments.registerSubModel(PathElement.pathElement((String)"subdeployment"), deployments);
        ManagementResourceRegistration extensions = root.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(root, deployments, (SubsystemXmlWriterRegistry)extensibleConfigurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationStepHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationStepHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-deployer-chains", (OperationStepHandler)DeployerChainAddHandler.INSTANCE, (DescriptionProvider)DeployerChainAddHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
    }
}

