/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;

public class ModuleIndexBuilder {
    private static final Logger logger = Logger.getLogger(ModuleIndexBuilder.class);
    public static final String INDEX_LOCATION = "META-INF/jandex.idx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompositeIndex buildCompositeIndex(Module module) {
        try {
            Enumeration resources = module.getClassLoader().getResources(INDEX_LOCATION);
            if (!resources.hasMoreElements()) {
                return null;
            }
            HashSet<Index> indexes = new HashSet<Index>();
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                InputStream stream = url.openStream();
                try {
                    IndexReader reader = new IndexReader(stream);
                    indexes.add(reader.read());
                }
                finally {
                    stream.close();
                }
            }
            return new CompositeIndex(indexes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ModuleIndexBuilder() {
    }
}

