/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorMetrics;
import org.jboss.as.web.WebConnectorRemove;
import org.jboss.as.web.WebSubsystemAdd;
import org.jboss.as.web.WebSubsystemDescribe;
import org.jboss.as.web.WebSubsystemDescriptionProviders;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.as.web.WebVirtualHostRemove;
import org.jboss.as.web.deployment.ServletDeploymentStats;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.web");
    public static final String SUBSYSTEM_NAME = "web";
    private static final PathElement connectorPath = PathElement.pathElement((String)"connector");
    private static final PathElement hostPath = PathElement.pathElement((String)"virtual-server");

    public void initialize(ExtensionContext context) {
        log.debugf("Activating Web Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WebSubsystemDescriptionProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WebSubsystemAdd.INSTANCE, (DescriptionProvider)WebSubsystemAdd.INSTANCE, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WebSubsystemDescribe.INSTANCE, (DescriptionProvider)WebSubsystemDescribe.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel(connectorPath, WebSubsystemDescriptionProviders.CONNECTOR);
        connectors.registerOperationHandler("add", (OperationStepHandler)WebConnectorAdd.INSTANCE, (DescriptionProvider)WebConnectorAdd.INSTANCE, false);
        connectors.registerOperationHandler("remove", (OperationStepHandler)WebConnectorRemove.INSTANCE, (DescriptionProvider)WebConnectorRemove.INSTANCE, false);
        for (String attributeName : WebConnectorMetrics.ATTRIBUTES) {
            connectors.registerMetric(attributeName, (OperationStepHandler)WebConnectorMetrics.INSTANCE);
        }
        ManagementResourceRegistration hosts = registration.registerSubModel(hostPath, WebSubsystemDescriptionProviders.VIRTUAL_SERVER);
        hosts.registerOperationHandler("add", (OperationStepHandler)WebVirtualHostAdd.INSTANCE, (DescriptionProvider)WebVirtualHostAdd.INSTANCE, false);
        hosts.registerOperationHandler("remove", (OperationStepHandler)WebVirtualHostRemove.INSTANCE, (DescriptionProvider)WebVirtualHostRemove.INSTANCE, false);
        DescriptionProvider NULL = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return new ModelNode();
            }
        };
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(NULL);
        ManagementResourceRegistration servlets = deployments.registerSubModel(PathElement.pathElement((String)"servlet"), NULL);
        ServletDeploymentStats.register(servlets);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
    }
}

