/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.hibernate.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    @Override
    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        properties.put("hibernate.id.new_generator_mappings", "true");
        properties.put("hibernate.ejb.resource_scanner", "org.jboss.as.jpa.hibernate.HibernateAnnotationScanner");
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        properties.put("hibernate.transaction.jta.platform", new JBossAppServerJtaPlatform());
    }

    @Override
    public Iterable<ServiceName> getProviderDependencies(PersistenceUnitMetadata pu) {
        String cacheManager = pu.getProperties().getProperty("hibernate.cache.infinispan.cachemanager");
        if (cacheManager != null) {
            ArrayList<ServiceName> result = new ArrayList<ServiceName>();
            result.add(this.adjustJndiName(cacheManager));
            return result;
        }
        return null;
    }

    private ServiceName adjustJndiName(String jndiName) {
        int index = (jndiName = HibernatePersistenceProviderAdaptor.toJndiName(jndiName).toString()).indexOf("/");
        String namespace = index > 5 ? jndiName.substring(5, index) : null;
        String binding = index > 5 ? jndiName.substring(index + 1) : jndiName.substring(5);
        ServiceName naming = namespace != null ? ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{namespace}) : ContextNames.JAVA_CONTEXT_SERVICE_NAME;
        return naming.append(new String[]{binding});
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)"java:jboss").append(value.startsWith("/") ? value.substring(1) : value);
    }

    @Override
    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.setThreadLocalPersistenceUnitMetadata(pu);
    }

    @Override
    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.clearThreadLocalPersistenceUnitMetadata();
    }
}

