/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.util.Util;

public class GetStateTest
implements Runnable {
    Channel channel;
    int[] state;
    Thread getter = null;
    boolean rc = false;

    public void start() throws Exception {
        String props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;print_local_addr=true):pbcast.STATE_TRANSFER";
        this.channel = new JChannel(props);
        this.channel.connect("TestChannel");
        System.out.println("Getting state");
        this.rc = this.channel.getState(null, 3000L);
        System.out.println("getState(), rc=" + this.rc);
        if (!this.rc) {
            this.state = new int[3];
            this.state[0] = 1;
            this.state[1] = 2;
            this.state[2] = 3;
        }
        System.out.println("State is\n" + this.printState(this.state));
        Util.sleep(2000L);
        this.getter = new Thread((Runnable)this, "Getter");
        this.getter.start();
        while (true) {
            Message update = new Message(null);
            int index = (int)(Math.random() * 10.0 % 3.0);
            try {
                update.setBuffer(Util.objectToByteBuffer(new Integer(index)));
            }
            catch (Exception e) {
                System.err.println(e);
            }
            System.out.println("Sending update for index " + index);
            this.channel.send(update);
            Util.sleep(2000L);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block5: while (true) {
            while (true) {
                Object new_state;
                Object ret;
                if ((ret = this.channel.receive(0L)) instanceof Message) {
                    Message m = (Message)ret;
                    try {
                        Integer index = (Integer)m.getObject();
                        int in = index;
                        if (this.state == null) continue block5;
                        System.out.println("state[" + in + "]=" + (this.state[in] + 1));
                        int n = index;
                        this.state[n] = this.state[n] + 1;
                        continue block5;
                    }
                    catch (ClassCastException cast_ex) {
                        System.out.println("Contents of buffer was no Integer !");
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (ret instanceof GetStateEvent) {
                    System.out.println("----> State transfer: " + ret);
                    this.channel.returnState(Util.objectToByteBuffer(this.state));
                    continue;
                }
                if (!(ret instanceof SetStateEvent) || (new_state = Util.objectFromByteBuffer(((SetStateEvent)ret).getArg())) == null) continue;
                this.state = (int[])new_state;
            }
            break;
        }
        catch (Exception exception) {
            return;
        }
    }

    String printState(int[] vec) {
        StringBuilder ret = new StringBuilder();
        if (vec != null) {
            for (int i = 0; i < vec.length; ++i) {
                ret.append("state[" + i + "]: " + vec[i] + '\n');
            }
        }
        return ret.toString();
    }

    public static void main(String[] args) {
        try {
            new GetStateTest().start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

